/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.backpressure.settings;

import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;

public class NodeDuressSettings {
    private volatile int numSuccessiveBreaches;
    public static final Setting<Integer> SETTING_NUM_SUCCESSIVE_BREACHES = Setting.intSetting("search_backpressure.node_duress.num_successive_breaches", 3, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double cpuThreshold;
    public static final Setting<Double> SETTING_CPU_THRESHOLD = Setting.doubleSetting("search_backpressure.node_duress.cpu_threshold", 0.9, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double heapThreshold;
    public static final Setting<Double> SETTING_HEAP_THRESHOLD = Setting.doubleSetting("search_backpressure.node_duress.heap_threshold", 0.7, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public NodeDuressSettings(Settings settings, ClusterSettings clusterSettings) {
        this.numSuccessiveBreaches = SETTING_NUM_SUCCESSIVE_BREACHES.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_NUM_SUCCESSIVE_BREACHES, this::setNumSuccessiveBreaches);
        this.cpuThreshold = SETTING_CPU_THRESHOLD.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_CPU_THRESHOLD, this::setCpuThreshold);
        this.heapThreshold = SETTING_HEAP_THRESHOLD.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_HEAP_THRESHOLD, this::setHeapThreshold);
    }

    public int getNumSuccessiveBreaches() {
        return this.numSuccessiveBreaches;
    }

    private void setNumSuccessiveBreaches(int numSuccessiveBreaches) {
        this.numSuccessiveBreaches = numSuccessiveBreaches;
    }

    public double getCpuThreshold() {
        return this.cpuThreshold;
    }

    private void setCpuThreshold(double cpuThreshold) {
        this.cpuThreshold = cpuThreshold;
    }

    public double getHeapThreshold() {
        return this.heapThreshold;
    }

    private void setHeapThreshold(double heapThreshold) {
        this.heapThreshold = heapThreshold;
    }

    private static class Defaults {
        private static final int NUM_SUCCESSIVE_BREACHES = 3;
        private static final double CPU_THRESHOLD = 0.9;
        private static final double HEAP_THRESHOLD = 0.7;

        private Defaults() {
        }
    }
}

