/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentLocation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InvalidAggregationPathException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.AggregationPath;

public class BucketHelpers {
    public static Double resolveBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath, GapPolicy gapPolicy) {
        List<String> aggPathsList = AggregationPath.parse(aggPath).getPathElementsAsStringList();
        return BucketHelpers.resolveBucketValue(agg, bucket, aggPathsList, gapPolicy);
    }

    public static Double resolveBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, List<String> aggPathAsList, GapPolicy gapPolicy) {
        try {
            boolean isDocCountProperty;
            double value;
            Object propertyValue = bucket.getProperty(agg.getName(), aggPathAsList);
            if (propertyValue == null) {
                throw new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation");
            }
            if (propertyValue instanceof Number) {
                value = ((Number)propertyValue).doubleValue();
            } else if (propertyValue instanceof InternalNumericMetricsAggregation.SingleValue) {
                value = ((InternalNumericMetricsAggregation.SingleValue)propertyValue).value();
            } else {
                throw BucketHelpers.formatResolutionError(agg, aggPathAsList, propertyValue);
            }
            boolean bl = isDocCountProperty = aggPathAsList.size() == 1 && "_count".equals(aggPathAsList.get(0));
            if (Double.isInfinite(value) || Double.isNaN(value) || bucket.getDocCount() == 0L && !isDocCountProperty) {
                switch (gapPolicy.ordinal()) {
                    case 0: {
                        return 0.0;
                    }
                }
                return Double.NaN;
            }
            return value;
        }
        catch (InvalidAggregationPathException e) {
            return null;
        }
    }

    private static AggregationExecutionException formatResolutionError(MultiBucketsAggregation agg, List<String> aggPathAsList, Object propertyValue) {
        Object currentAgg;
        String currentAggName;
        if (aggPathAsList.isEmpty()) {
            currentAggName = agg.getName();
            currentAgg = agg;
        } else {
            currentAggName = aggPathAsList.get(0);
            currentAgg = propertyValue;
        }
        if (currentAgg instanceof InternalNumericMetricsAggregation.MultiValue) {
            return new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation, but [" + currentAggName + "] contains multiple values. Please specify which to use.");
        }
        return new AggregationExecutionException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference either a number value or a single value numeric metric aggregation, got: [" + propertyValue.getClass().getSimpleName() + "] at aggregation [" + currentAggName + "]");
    }

    public static enum GapPolicy implements Writeable
    {
        INSERT_ZEROS(0, "insert_zeros"),
        SKIP(1, "skip");

        private final byte id;
        private final ParseField parseField;

        public static GapPolicy parse(String text, XContentLocation tokenLocation) {
            GapPolicy result = null;
            for (GapPolicy policy : GapPolicy.values()) {
                if (!policy.parseField.match(text, LoggingDeprecationHandler.INSTANCE)) continue;
                if (result == null) {
                    result = policy;
                    continue;
                }
                throw new IllegalStateException("Text can be parsed to 2 different gap policies: text=[" + text + "], policies=" + String.valueOf(Arrays.asList(result, policy)));
            }
            if (result == null) {
                ArrayList<String> validNames = new ArrayList<String>();
                for (GapPolicy policy : GapPolicy.values()) {
                    validNames.add(policy.getName());
                }
                throw new ParsingException(tokenLocation, "Invalid gap policy: [" + text + "], accepted values: " + String.valueOf(validNames), new Object[0]);
            }
            return result;
        }

        private GapPolicy(byte id, String name) {
            this.id = id;
            this.parseField = new ParseField(name, new String[0]);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public static GapPolicy readFrom(StreamInput in) throws IOException {
            byte id = in.readByte();
            for (GapPolicy gapPolicy : GapPolicy.values()) {
                if (id != gapPolicy.id) continue;
                return gapPolicy;
            }
            throw new IllegalStateException("Unknown GapPolicy with id [" + id + "]");
        }

        public String getName() {
            return this.parseField.getPreferredName();
        }
    }
}

