/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.IntArray;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AbstractHyperLogLog;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AbstractLinearCounting;

final class HyperLogLogPlusPlusSparse
extends AbstractHyperLogLogPlusPlus
implements Releasable {
    private final LinearCounting lc;

    HyperLogLogPlusPlusSparse(int precision, BigArrays bigArrays, int capacity, int initialSize) {
        super(precision);
        this.lc = new LinearCounting(precision, bigArrays, capacity, initialSize);
    }

    @Override
    public long maxOrd() {
        return this.lc.sizes.size();
    }

    @Override
    public long cardinality(long bucketOrd) {
        return this.lc.cardinality(bucketOrd);
    }

    @Override
    protected boolean getAlgorithm(long bucketOrd) {
        return false;
    }

    @Override
    protected AbstractLinearCounting.HashesIterator getLinearCounting(long bucketOrd) {
        return this.lc.values(bucketOrd);
    }

    @Override
    protected AbstractHyperLogLog.RunLenIterator getHyperLogLog(long bucketOrd) {
        throw new IllegalArgumentException("Implementation does not support HLL structures");
    }

    @Override
    public void collect(long bucket, long hash) {
        this.lc.collect(bucket, hash);
    }

    @Override
    public void close() {
        Releasables.close((Releasable)this.lc);
    }

    protected void addEncoded(long bucket, int encoded) {
        this.lc.addEncoded(bucket, encoded);
    }

    private static class LinearCounting
    extends AbstractLinearCounting
    implements Releasable {
        private final int capacity;
        private final BigArrays bigArrays;
        private final LinearCountingIterator iterator;
        private IntArray values;
        private IntArray sizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        LinearCounting(int p, BigArrays bigArrays, int capacity, int initialSize) {
            IntArray sizes;
            IntArray values;
            block3: {
                super(p);
                this.bigArrays = bigArrays;
                this.capacity = capacity;
                values = null;
                sizes = null;
                boolean success = false;
                try {
                    values = bigArrays.newIntArray(initialSize * capacity);
                    sizes = bigArrays.newIntArray(initialSize);
                    success = true;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close(values, sizes);
                    }
                    throw throwable;
                }
                Releasables.close(values, sizes);
            }
            this.values = values;
            this.sizes = sizes;
            this.iterator = new LinearCountingIterator(this, capacity);
        }

        @Override
        protected int addEncoded(long bucketOrd, int encoded) {
            assert (encoded != 0);
            return this.set(bucketOrd, encoded);
        }

        @Override
        protected int size(long bucketOrd) {
            if (bucketOrd >= this.sizes.size()) {
                return 0;
            }
            int size = this.sizes.get(bucketOrd);
            assert (size == this.recomputedSize(bucketOrd));
            return size;
        }

        @Override
        protected AbstractLinearCounting.HashesIterator values(long bucketOrd) {
            this.iterator.reset(bucketOrd, this.size(bucketOrd));
            return this.iterator;
        }

        private long index(long bucketOrd, int index) {
            return bucketOrd * (long)this.capacity + (long)index;
        }

        private int get(long bucketOrd, int index) {
            long globalIndex = this.index(bucketOrd, index);
            if (this.values.size() < globalIndex) {
                return 0;
            }
            return this.values.get(globalIndex);
        }

        private int set(long bucketOrd, int value) {
            int size = this.size(bucketOrd);
            if (size == 0) {
                this.sizes = this.bigArrays.grow(this.sizes, bucketOrd + 1L);
                this.values = this.bigArrays.grow(this.values, (bucketOrd + 1L) * (long)this.capacity);
            }
            this.values.set(this.index(bucketOrd, size), value);
            return this.sizes.increment(bucketOrd, 1);
        }

        private int recomputedSize(long bucketOrd) {
            for (int i = 0; i < this.capacity; ++i) {
                int v = this.get(bucketOrd, i);
                if (v != 0) continue;
                return i;
            }
            return this.capacity;
        }

        @Override
        public void close() {
            Releasables.close(this.values, this.sizes);
        }
    }

    private static class LinearCountingIterator
    implements AbstractLinearCounting.HashesIterator {
        private final LinearCounting lc;
        private final int capacity;
        long start;
        long end;
        private int value;
        private int size;
        private long pos;

        LinearCountingIterator(LinearCounting lc, int capacity) {
            this.lc = lc;
            this.capacity = capacity;
        }

        void reset(long bucketOrd, int size) {
            this.start = bucketOrd * (long)this.capacity;
            this.size = size;
            this.end = this.start + (long)size;
            this.pos = this.start;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean next() {
            if (this.pos < this.end) {
                this.value = this.lc.values.get(this.pos++);
                return true;
            }
            return false;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

