/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.misc.search.DiversifiedTopDocsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocsCollector;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class DiversifiedNumericSamplerAggregator
extends SamplerAggregator {
    private ValuesSource.Numeric valuesSource;
    private int maxDocsPerValue;

    DiversifiedNumericSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata, ValuesSourceConfig valuesSourceConfig, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
        this.maxDocsPerValue = maxDocsPerValue;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector(x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector(Consumer<Long> circuitBreakerConsumer) {
            super(DiversifiedNumericSamplerAggregator.this.shardSize, DiversifiedNumericSamplerAggregator.this.context.bigArrays(), circuitBreakerConsumer);
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            int minMaxDocsPerValue = Math.min(DiversifiedNumericSamplerAggregator.this.maxDocsPerValue, DiversifiedNumericSamplerAggregator.this.context.searcher().getIndexReader().maxDoc());
            return new ValuesDiversifiedTopDocsCollector(size, minMaxDocsPerValue);
        }

        @Override
        protected long getPriorityQueueSlotSize() {
            return SamplerAggregator.SCOREDOCKEY_SIZE;
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedNumericDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedNumericSamplerAggregator.this.valuesSource.longValues(context);
                }
                catch (IOException e) {
                    throw new OpenSearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return ValuesDiversifiedTopDocsCollector.this.values.docID();
                    }

                    @Override
                    public long longValue() throws IOException {
                        return ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                    }
                };
            }
        }
    }
}

