/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.CardinalityUpperBound;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.SingleBucketAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.InternalFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class FilterAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final Supplier<Weight> filter;

    public FilterAggregator(String name, Supplier<Weight> filter, AggregatorFactories factories, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        this.filter = filter;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits bits = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filter.get().scorerSupplier(ctx));
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bits.get(doc)) {
                    FilterAggregator.this.collectBucket(sub, doc, bucket);
                }
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalFilter(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalFilter(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }
}

