/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class ScriptContextInfo
implements ToXContentObject,
Writeable {
    public final String name;
    public final ScriptMethodInfo execute;
    public final Set<ScriptMethodInfo> getters;
    private static final String NAME_FIELD = "name";
    private static final String METHODS_FIELD = "methods";
    public static final ConstructingObjectParser<ScriptContextInfo, Void> PARSER = new ConstructingObjectParser<ScriptContextInfo, Void>("script_context_info", true, (m, name) -> new ScriptContextInfo((String)m[0], (List)m[1]));

    ScriptContextInfo(String name, Class<?> clazz) {
        this.name = name;
        this.execute = ScriptMethodInfo.executeFromContext(clazz);
        this.getters = Collections.unmodifiableSet(ScriptMethodInfo.gettersFromContext(clazz));
    }

    ScriptContextInfo(String name, List<ScriptMethodInfo> methods) {
        this.name = Objects.requireNonNull(name);
        Objects.requireNonNull(methods);
        String executeName = "execute";
        String getName = "get";
        String otherName = "other";
        Map<String, List<ScriptMethodInfo>> methodTypes = methods.stream().collect(Collectors.groupingBy(m -> {
            if (m.name.equals(executeName)) {
                return executeName;
            }
            if (m.name.startsWith(getName) && m.parameters.size() == 0) {
                return getName;
            }
            return otherName;
        }));
        if (!methodTypes.containsKey(executeName)) {
            throw new IllegalArgumentException("Could not find required method [" + executeName + "] in [" + name + "], found " + methods.stream().map(m -> m.name).sorted().collect(Collectors.joining(", ", "[", "]")));
        }
        if (methodTypes.get(executeName).size() != 1) {
            throw new IllegalArgumentException("Cannot have multiple [execute] methods in [" + name + "], found [" + methodTypes.get(executeName).size() + "]");
        }
        this.execute = methodTypes.get(executeName).get(0);
        this.getters = methodTypes.containsKey(getName) ? Collections.unmodifiableSet(new HashSet(methodTypes.get(getName))) : Collections.emptySet();
    }

    public ScriptContextInfo(String name, ScriptMethodInfo execute, Set<ScriptMethodInfo> getters) {
        this.name = Objects.requireNonNull(name);
        this.execute = Objects.requireNonNull(execute);
        this.getters = Objects.requireNonNull(getters);
    }

    public ScriptContextInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.execute = new ScriptMethodInfo(in);
        int numGetters = in.readInt();
        HashSet<ScriptMethodInfo> getters = new HashSet<ScriptMethodInfo>(numGetters);
        for (int i = 0; i < numGetters; ++i) {
            getters.add(new ScriptMethodInfo(in));
        }
        this.getters = Collections.unmodifiableSet(getters);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        this.execute.writeTo(out);
        out.writeInt(this.getters.size());
        for (ScriptMethodInfo getter : this.getters) {
            getter.writeTo(out);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<ScriptMethodInfo> methods() {
        ArrayList<ScriptMethodInfo> methods = new ArrayList<ScriptMethodInfo>();
        methods.add(this.execute);
        methods.addAll(this.getters);
        return Collections.unmodifiableList(methods);
    }

    public static ScriptContextInfo fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptContextInfo that = (ScriptContextInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.execute, that.execute) && Objects.equals(this.getters, that.getters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.execute, this.getters);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(NAME_FIELD, this.name).startArray(METHODS_FIELD);
        this.execute.toXContent(builder, params);
        for (ScriptMethodInfo method : this.getters.stream().sorted(Comparator.comparing(g -> g.name)).collect(Collectors.toList())) {
            method.toXContent(builder, params);
        }
        return builder.endArray().endObject();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(NAME_FIELD, new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ctx) -> ScriptMethodInfo.PARSER.apply(parser, (Void)ctx), new ParseField(METHODS_FIELD, new String[0]));
    }

    @PublicApi(since="1.0.0")
    public static class ScriptMethodInfo
    implements ToXContentObject,
    Writeable {
        public final String name;
        public final String returnType;
        public final List<ParameterInfo> parameters;
        static final String RETURN_TYPE_FIELD = "return_type";
        static final String PARAMETERS_FIELD = "params";
        private static final ConstructingObjectParser<ScriptMethodInfo, Void> PARSER = new ConstructingObjectParser<ScriptMethodInfo, Void>("method", true, (m, name) -> new ScriptMethodInfo((String)m[0], (String)m[1], (List)m[2]));

        public ScriptMethodInfo(String name, String returnType, List<ParameterInfo> parameters) {
            this.name = Objects.requireNonNull(name);
            this.returnType = Objects.requireNonNull(returnType);
            this.parameters = Collections.unmodifiableList(Objects.requireNonNull(parameters));
        }

        public ScriptMethodInfo(StreamInput in) throws IOException {
            this.name = in.readString();
            this.returnType = in.readString();
            int numParameters = in.readInt();
            ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>(numParameters);
            for (int i = 0; i < numParameters; ++i) {
                parameters.add(new ParameterInfo(in));
            }
            this.parameters = Collections.unmodifiableList(parameters);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.returnType);
            out.writeInt(this.parameters.size());
            for (ParameterInfo parameter : this.parameters) {
                parameter.writeTo(out);
            }
        }

        public static ScriptMethodInfo fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptMethodInfo that = (ScriptMethodInfo)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.returnType, this.parameters);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field(ScriptContextInfo.NAME_FIELD, this.name).field(RETURN_TYPE_FIELD, this.returnType).startArray(PARAMETERS_FIELD);
            for (ParameterInfo parameter : this.parameters) {
                parameter.toXContent(builder, params);
            }
            return builder.endArray().endObject();
        }

        static ScriptMethodInfo executeFromContext(Class<?> clazz) {
            Method execute = null;
            String name = "execute";
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name)) continue;
                if (execute != null) {
                    throw new IllegalArgumentException("Cannot have multiple [" + name + "] methods on class [" + clazz.getName() + "]");
                }
                execute = method;
            }
            if (execute == null) {
                throw new IllegalArgumentException("Could not find required method [" + name + "] on class [" + clazz.getName() + "]");
            }
            Class<?> returnTypeClazz = execute.getReturnType();
            String returnType = returnTypeClazz.getTypeName();
            Class<?>[] parameterTypes = execute.getParameterTypes();
            ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
            if (parameterTypes.length > 0) {
                String[] argumentNames;
                Field parameterNamesField;
                String parametersFieldName = "PARAMETERS";
                try {
                    parameterNamesField = clazz.getField(parametersFieldName);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Could not find field [" + parametersFieldName + "] on instance class [" + clazz.getName() + "] but method [" + name + "] has [" + parameterTypes.length + "] parameters");
                }
                if (!parameterNamesField.getType().equals(String[].class)) {
                    throw new IllegalArgumentException("Expected a constant [String[] PARAMETERS] on instance class [" + clazz.getName() + "] for method [" + name + "] with [" + parameterTypes.length + "] parameters, found [" + parameterNamesField.getType().getTypeName() + "]");
                }
                try {
                    argumentNames = (String[])parameterNamesField.get(null);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalArgumentException("Error trying to read [" + clazz.getName() + "#ARGUMENTS]", e);
                }
                if (argumentNames.length != parameterTypes.length) {
                    throw new IllegalArgumentException("Expected argument names [" + argumentNames.length + "] to have the same arity [" + parameterTypes.length + "] for method [" + name + "] of class [" + clazz.getName() + "]");
                }
                for (int i = 0; i < argumentNames.length; ++i) {
                    parameters.add(new ParameterInfo(parameterTypes[i].getTypeName(), argumentNames[i]));
                }
            }
            return new ScriptMethodInfo(name, returnType, parameters);
        }

        static Set<ScriptMethodInfo> gettersFromContext(Class<?> clazz) {
            HashSet<ScriptMethodInfo> getters = new HashSet<ScriptMethodInfo>();
            for (Method m : clazz.getMethods()) {
                if (m.isDefault() || !m.getName().startsWith("get") || m.getName().equals("getClass") || Modifier.isStatic(m.getModifiers()) || m.getParameters().length != 0) continue;
                getters.add(new ScriptMethodInfo(m.getName(), m.getReturnType().getTypeName(), new ArrayList<ParameterInfo>()));
            }
            return getters;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ScriptContextInfo.NAME_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(RETURN_TYPE_FIELD, new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ctx) -> ParameterInfo.PARSER.apply(parser, (Void)ctx), new ParseField(PARAMETERS_FIELD, new String[0]));
        }

        public static class ParameterInfo
        implements ToXContentObject,
        Writeable {
            public final String type;
            public final String name;
            public static final String TYPE_FIELD = "type";
            private static final ConstructingObjectParser<ParameterInfo, Void> PARSER = new ConstructingObjectParser("parameters", true, p -> new ParameterInfo((String)p[0], (String)p[1]));

            public ParameterInfo(String type, String name) {
                this.type = Objects.requireNonNull(type);
                this.name = Objects.requireNonNull(name);
            }

            public ParameterInfo(StreamInput in) throws IOException {
                this.type = in.readString();
                this.name = in.readString();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.type);
                out.writeString(this.name);
            }

            public static ParameterInfo fromXContent(XContentParser parser) throws IOException {
                return PARSER.parse(parser, null);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject().field(TYPE_FIELD, this.type).field(ScriptContextInfo.NAME_FIELD, this.name).endObject();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ParameterInfo that = (ParameterInfo)o;
                return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.name);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(TYPE_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(ScriptContextInfo.NAME_FIELD, new String[0]));
            }
        }
    }
}

