/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.index.VersionType;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestActions;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourceContext;

public class RestGetAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "document_get_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_doc/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_doc/{id}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] fields;
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("the parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or [_source] to load the field from _source");
        }
        String fieldsParam = request.param("stored_fields");
        if (fieldsParam != null && (fields = Strings.splitStringByCommaToArray(fieldsParam)) != null) {
            getRequest.storedFields(fields);
        }
        getRequest.version(RestActions.parseVersion(request));
        getRequest.versionType(VersionType.fromString(request.param("version_type"), getRequest.versionType()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.get(getRequest, (ActionListener<GetResponse>)new RestToXContentListener<GetResponse>(channel){

            @Override
            protected RestStatus getStatus(GetResponse response) {
                return response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }
}

