/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.open.OpenIndexAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.LoggingTaskListener;

public class RestOpenIndexAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestOpenIndexAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_open"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_open")));
    }

    @Override
    public String getName() {
        return "open_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        OpenIndexRequest openIndexRequest = new OpenIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        openIndexRequest.timeout(request.paramAsTime("timeout", openIndexRequest.timeout()));
        openIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", openIndexRequest.clusterManagerNodeTimeout()));
        RestOpenIndexAction.parseDeprecatedMasterTimeoutParameter(openIndexRequest, request);
        openIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, openIndexRequest.indicesOptions()));
        String waitForActiveShards = request.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            openIndexRequest.waitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if (request.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.admin().indices().open(openIndexRequest, new RestToXContentListener<OpenIndexResponse>((RestChannel)channel));
        }
        openIndexRequest.setShouldStoreResult(true);
        openIndexRequest.timeout(request.paramAsTime("task_execution_timeout", AcknowledgedRequest.DEFAULT_TASK_EXECUTION_TIMEOUT));
        ActionRequestValidationException validationException = openIndexRequest.validate();
        if (validationException != null) {
            throw validationException;
        }
        return this.sendTask(client.getLocalNodeId(), client.executeLocally(OpenIndexAction.INSTANCE, openIndexRequest, LoggingTaskListener.instance()));
    }
}

