/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.stats.RemoteStoreStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.remotestore.stats.RemoteStoreStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;

public class RestRemoteStoreStatsAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/stats/{index}"), new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/stats/{index}/{shard_id}")));
    }

    @Override
    public String getName() {
        return "remote_store_stats";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String index = request.param("index");
        String shardId = request.param("shard_id");
        boolean local = Objects.equals(request.param("local"), "true");
        RemoteStoreStatsRequest remoteStoreStatsRequest = new RemoteStoreStatsRequest();
        if (index != null) {
            remoteStoreStatsRequest.indices(new String[]{index});
        }
        if (shardId != null) {
            remoteStoreStatsRequest.shards(shardId);
        }
        remoteStoreStatsRequest.local(local);
        return channel -> client.admin().cluster().remoteStoreStats(remoteStoreStatsRequest, new RestToXContentListener<RemoteStoreStatsResponse>((RestChannel)channel));
    }
}

