/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.repositories.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Random;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoryMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Randomness;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.fs.FsBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.fs.FsBlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.fs.FsRepository;

public class ReloadableFsRepository
extends FsRepository {
    public static final String TYPE = "reloadable-fs";
    private final FailSwitch fail = new FailSwitch();
    private final SlowDownWriteSwitch slowDown;
    public static final Setting<Integer> REPOSITORIES_FAILRATE_SETTING = Setting.intSetting("repositories.fail.rate", 0, 0, 100, Setting.Property.NodeScope);
    public static final Setting<Integer> REPOSITORIES_SLOWDOWN_SETTING = Setting.intSetting("repositories.slowdown", 0, 0, 100, Setting.Property.NodeScope);

    public ReloadableFsRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, environment, namedXContentRegistry, clusterService, recoverySettings);
        this.fail.failRate(REPOSITORIES_FAILRATE_SETTING.get(metadata.settings()));
        this.slowDown = new SlowDownWriteSwitch();
        this.slowDown.setSleepSeconds(REPOSITORIES_SLOWDOWN_SETTING.get(metadata.settings()));
        this.readRepositoryMetadata();
    }

    @Override
    public boolean isReloadable() {
        return true;
    }

    @Override
    public void reload(RepositoryMetadata repositoryMetadata) {
        super.reload(repositoryMetadata);
        this.readRepositoryMetadata();
        this.validateLocation();
        this.readMetadata();
    }

    private void readRepositoryMetadata() {
        this.fail.failRate(REPOSITORIES_FAILRATE_SETTING.get(this.metadata.settings()));
        this.slowDown.setSleepSeconds(REPOSITORIES_SLOWDOWN_SETTING.get(this.metadata.settings()));
    }

    @Override
    protected BlobStore createBlobStore() throws Exception {
        String location = (String)REPOSITORIES_LOCATION_SETTING.get(this.getMetadata().settings());
        Path locationFile = this.environment.resolveRepoFile(location);
        return new ThrowingBlobStore(this.bufferSize, locationFile, this.isReadOnly(), this.fail, this.slowDown);
    }

    public static int randomIntBetween(int min, int max) {
        Random random = Randomness.get();
        return random.nextInt(max - min + 1) + min;
    }

    static class FailSwitch {
        private volatile int failRate;
        private volatile boolean onceFailedFailAlways = false;

        FailSwitch() {
        }

        public boolean fail() {
            boolean fail;
            int rnd = ReloadableFsRepository.randomIntBetween(1, 100);
            boolean bl = fail = rnd <= this.failRate;
            if (fail && this.onceFailedFailAlways) {
                this.failAlways();
            }
            return fail;
        }

        public void failAlways() {
            this.failRate = 100;
        }

        public void failRate(int rate) {
            this.failRate = rate;
        }

        public void onceFailedFailAlways() {
            this.onceFailedFailAlways = true;
        }
    }

    static class SlowDownWriteSwitch {
        private volatile int sleepSeconds;

        SlowDownWriteSwitch() {
        }

        public void setSleepSeconds(int sleepSeconds) {
            this.sleepSeconds = sleepSeconds;
        }

        public int getSleepSeconds() {
            return this.sleepSeconds;
        }
    }

    private static class ThrowingBlobStore
    extends FsBlobStore {
        private final FailSwitch fail;
        private final SlowDownWriteSwitch slowDown;

        public ThrowingBlobStore(int bufferSizeInBytes, Path path, boolean readonly, FailSwitch fail, SlowDownWriteSwitch slowDown) throws IOException {
            super(bufferSizeInBytes, path, readonly);
            this.fail = fail;
            this.slowDown = slowDown;
        }

        @Override
        public BlobContainer blobContainer(BlobPath path) {
            try {
                return new ThrowingBlobContainer(this, path, this.buildAndCreate(path), this.fail, this.slowDown);
            }
            catch (IOException ex) {
                throw new OpenSearchException("failed to create blob container", (Throwable)ex, new Object[0]);
            }
        }
    }

    private static class ThrowingBlobContainer
    extends FsBlobContainer {
        private final FailSwitch fail;
        private final SlowDownWriteSwitch slowDown;

        public ThrowingBlobContainer(FsBlobStore blobStore, BlobPath blobPath, Path path, FailSwitch fail, SlowDownWriteSwitch slowDown) {
            super(blobStore, blobPath, path);
            this.fail = fail;
            this.slowDown = slowDown;
        }

        @Override
        public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
            this.checkFailRateAndSleep(blobName);
            super.writeBlobAtomic(blobName, inputStream, blobSize, failIfAlreadyExists);
        }

        private void checkFailRateAndSleep(String blobName) throws IOException {
            if (this.fail.fail() && !blobName.contains(".dat")) {
                throw new IOException("blob container throwing error");
            }
            if (this.slowDown.getSleepSeconds() > 0) {
                try {
                    Thread.sleep((long)this.slowDown.getSleepSeconds() * 1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
            this.checkFailRateAndSleep(blobName);
            super.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
        }
    }
}

