/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.persistent.decider;

import java.util.Locale;
import java.util.Objects;

public final class AssignmentDecision {
    public static final AssignmentDecision YES = new AssignmentDecision(Type.YES, "");
    private final Type type;
    private final String reason;

    public AssignmentDecision(Type type, String reason) {
        this.type = Objects.requireNonNull(type);
        this.reason = Objects.requireNonNull(reason);
    }

    public Type getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "assignment decision [type=" + String.valueOf((Object)this.type) + ", reason=" + this.reason + "]";
    }

    public static enum Type {
        NO(0),
        YES(1);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Type resolve(String s) {
            return Type.valueOf(s.toUpperCase(Locale.ROOT));
        }
    }
}

