/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.node.resource.tracker.AbstractAverageUsageTracker;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class AverageMemoryUsageTracker
extends AbstractAverageUsageTracker {
    private static final Logger LOGGER = LogManager.getLogger(AverageMemoryUsageTracker.class);
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();

    public AverageMemoryUsageTracker(ThreadPool threadPool, TimeValue pollingInterval, TimeValue windowDuration) {
        super(threadPool, pollingInterval, windowDuration);
    }

    @Override
    public long getUsage() {
        long usage = MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed() * 100L / MEMORY_MX_BEAN.getHeapMemoryUsage().getMax();
        LOGGER.debug("Recording memory usage: {}%", (Object)usage);
        return usage;
    }
}

