/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public class ReplicationTimer
implements Writeable {
    private long startTime = 0L;
    private long startNanoTime = 0L;
    private long time = -1L;
    private long stopTime = 0L;

    public ReplicationTimer() {
    }

    public ReplicationTimer(StreamInput in) throws IOException {
        this.startTime = in.readVLong();
        this.startNanoTime = in.readVLong();
        this.stopTime = in.readVLong();
        this.time = in.readVLong();
    }

    @Override
    public synchronized void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.startTime);
        out.writeVLong(this.startNanoTime);
        out.writeVLong(this.stopTime);
        out.writeVLong(this.time());
    }

    public synchronized void start() {
        assert (this.startTime == 0L) : "already started";
        this.startTime = System.currentTimeMillis();
        this.startNanoTime = System.nanoTime();
    }

    public synchronized long startTime() {
        return this.startTime;
    }

    public synchronized long time() {
        if (this.startNanoTime == 0L) {
            return 0L;
        }
        if (this.time >= 0L) {
            return this.time;
        }
        return Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - this.startNanoTime));
    }

    public synchronized long stopTime() {
        return this.stopTime;
    }

    public synchronized void stop() {
        assert (this.stopTime == 0L) : "already stopped";
        this.stopTime = Math.max(System.currentTimeMillis(), this.startTime);
        this.time = TimeValue.nsecToMSec(System.nanoTime() - this.startNanoTime);
        assert (this.time >= 0L);
    }

    public synchronized void reset() {
        this.startTime = 0L;
        this.startNanoTime = 0L;
        this.time = -1L;
        this.stopTime = 0L;
    }

    public long getStartNanoTime() {
        return this.startNanoTime;
    }
}

