/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public interface SegmentReplicationSource {
    public void getCheckpointMetadata(long var1, ReplicationCheckpoint var3, ActionListener<CheckpointInfoResponse> var4);

    public void getSegmentFiles(long var1, ReplicationCheckpoint var3, List<StoreFileMetadata> var4, IndexShard var5, BiConsumer<String, Long> var6, ActionListener<GetSegmentFilesResponse> var7);

    public String getDescription();

    default public void cancel() {
    }

    public static final class ReplicationStatsDirectoryWrapper
    extends FilterDirectory {
        private final BiConsumer<String, Long> fileProgressTracker;

        ReplicationStatsDirectoryWrapper(Directory in, BiConsumer<String, Long> fileProgressTracker) {
            super(in);
            this.fileProgressTracker = fileProgressTracker;
        }

        @Override
        public void copyFrom(Directory from, String src, final String dest, IOContext context) throws IOException {
            this.in.copyFrom(new FilterDirectory(from){

                @Override
                public IndexInput openInput(String name, IOContext context) throws IOException {
                    final IndexInput input = this.in.openInput(name, context);
                    return new IndexInput("StatsDirectoryWrapper(" + input.toString() + ")"){

                        @Override
                        public void close() throws IOException {
                            input.close();
                        }

                        @Override
                        public long getFilePointer() {
                            throw new UnsupportedOperationException("only straight copies are supported");
                        }

                        @Override
                        public void seek(long pos) throws IOException {
                            throw new UnsupportedOperationException("seeks are not supported");
                        }

                        @Override
                        public long length() {
                            return input.length();
                        }

                        @Override
                        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                            throw new UnsupportedOperationException("slices are not supported");
                        }

                        @Override
                        public byte readByte() throws IOException {
                            throw new UnsupportedOperationException("use a buffer if you wanna perform well");
                        }

                        @Override
                        public void readBytes(byte[] b, int offset, int len) throws IOException {
                            input.readBytes(b, offset, len);
                            fileProgressTracker.accept(dest, Long.valueOf(len));
                        }
                    };
                }
            }, src, dest, context);
        }
    }
}

