/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.SegmentReplicationTransportRequest;

public class GetSegmentFilesRequest
extends SegmentReplicationTransportRequest {
    private final List<StoreFileMetadata> filesToFetch;
    private final ReplicationCheckpoint checkpoint;

    public GetSegmentFilesRequest(StreamInput in) throws IOException {
        super(in);
        this.filesToFetch = in.readList(StoreFileMetadata::new);
        this.checkpoint = new ReplicationCheckpoint(in);
    }

    public GetSegmentFilesRequest(long replicationId, String targetAllocationId, DiscoveryNode targetNode, List<StoreFileMetadata> filesToFetch, ReplicationCheckpoint checkpoint) {
        super(replicationId, targetAllocationId, targetNode);
        this.filesToFetch = filesToFetch;
        this.checkpoint = checkpoint;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.filesToFetch);
        this.checkpoint.writeTo(out);
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public List<StoreFileMetadata> getFilesToFetch() {
        return this.filesToFetch;
    }
}

