/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.RemoteTranslogStats;

@PublicApi(since="1.0.0")
public class TranslogStats
implements Writeable,
ToXContentFragment {
    private static final String TRANSLOG = "translog";
    private long translogSizeInBytes;
    private int numberOfOperations;
    private long uncommittedSizeInBytes;
    private int uncommittedOperations;
    private long earliestLastModifiedAge;
    private final RemoteTranslogStats remoteTranslogStats;

    public TranslogStats() {
        this.remoteTranslogStats = new RemoteTranslogStats();
    }

    public TranslogStats(StreamInput in) throws IOException {
        this.numberOfOperations = in.readVInt();
        this.translogSizeInBytes = in.readVLong();
        this.uncommittedOperations = in.readVInt();
        this.uncommittedSizeInBytes = in.readVLong();
        this.earliestLastModifiedAge = in.readVLong();
        this.remoteTranslogStats = in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readOptionalWriteable(RemoteTranslogStats::new) : new RemoteTranslogStats();
    }

    public TranslogStats(int numberOfOperations, long translogSizeInBytes, int uncommittedOperations, long uncommittedSizeInBytes, long earliestLastModifiedAge) {
        if (numberOfOperations < 0) {
            throw new IllegalArgumentException("numberOfOperations must be >= 0");
        }
        if (translogSizeInBytes < 0L) {
            throw new IllegalArgumentException("translogSizeInBytes must be >= 0");
        }
        if (uncommittedOperations < 0) {
            throw new IllegalArgumentException("uncommittedOperations must be >= 0");
        }
        if (uncommittedSizeInBytes < 0L) {
            throw new IllegalArgumentException("uncommittedSizeInBytes must be >= 0");
        }
        if (earliestLastModifiedAge < 0L) {
            throw new IllegalArgumentException("earliestLastModifiedAge must be >= 0");
        }
        this.numberOfOperations = numberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
        this.uncommittedSizeInBytes = uncommittedSizeInBytes;
        this.uncommittedOperations = uncommittedOperations;
        this.earliestLastModifiedAge = earliestLastModifiedAge;
        this.remoteTranslogStats = new RemoteTranslogStats();
    }

    public void addRemoteTranslogStats(RemoteTranslogStats remoteTranslogStats) {
        if (this.remoteTranslogStats != null) {
            this.remoteTranslogStats.add(remoteTranslogStats);
        }
    }

    public void add(TranslogStats other) {
        if (other == null) {
            return;
        }
        this.numberOfOperations += other.numberOfOperations;
        this.translogSizeInBytes += other.translogSizeInBytes;
        this.uncommittedOperations += other.uncommittedOperations;
        this.uncommittedSizeInBytes += other.uncommittedSizeInBytes;
        this.earliestLastModifiedAge = this.earliestLastModifiedAge == 0L ? other.earliestLastModifiedAge : Math.min(this.earliestLastModifiedAge, other.earliestLastModifiedAge);
        this.addRemoteTranslogStats(other.remoteTranslogStats);
    }

    public long getTranslogSizeInBytes() {
        return this.translogSizeInBytes;
    }

    public int estimatedNumberOfOperations() {
        return this.numberOfOperations;
    }

    public long getUncommittedSizeInBytes() {
        return this.uncommittedSizeInBytes;
    }

    public int getUncommittedOperations() {
        return this.uncommittedOperations;
    }

    public long getEarliestLastModifiedAge() {
        return this.earliestLastModifiedAge;
    }

    public RemoteTranslogStats getRemoteTranslogStats() {
        return this.remoteTranslogStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TRANSLOG);
        this.addLocalTranslogStatsXContent(builder);
        if (this.remoteTranslogStats != null) {
            builder = this.remoteTranslogStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numberOfOperations);
        out.writeVLong(this.translogSizeInBytes);
        out.writeVInt(this.uncommittedOperations);
        out.writeVLong(this.uncommittedSizeInBytes);
        out.writeVLong(this.earliestLastModifiedAge);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalWriteable(this.remoteTranslogStats);
        }
    }

    private void addLocalTranslogStatsXContent(XContentBuilder builder) throws IOException {
        builder.field("operations", this.numberOfOperations);
        builder.humanReadableField("size_in_bytes", "size", new ByteSizeValue(this.translogSizeInBytes));
        builder.field("uncommitted_operations", this.uncommittedOperations);
        builder.humanReadableField("uncommitted_size_in_bytes", "uncommitted_size", new ByteSizeValue(this.uncommittedSizeInBytes));
        builder.field("earliest_last_modified_age", this.earliestLastModifiedAge);
    }
}

