/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="2.7.0")
public class FileCacheStats
implements Writeable,
ToXContentFragment {
    private final long timestamp;
    private final long active;
    private final long total;
    private final long used;
    private final long evicted;
    private final long hits;
    private final long misses;

    public FileCacheStats(long timestamp, long active, long total, long used, long evicted, long hits, long misses) {
        this.timestamp = timestamp;
        this.active = active;
        this.total = total;
        this.used = used;
        this.evicted = evicted;
        this.hits = hits;
        this.misses = misses;
    }

    public FileCacheStats(StreamInput in) throws IOException {
        this.timestamp = in.readLong();
        this.active = in.readLong();
        this.total = in.readLong();
        this.used = in.readLong();
        this.evicted = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.active);
        out.writeLong(this.total);
        out.writeLong(this.used);
        out.writeLong(this.evicted);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ByteSizeValue getTotal() {
        return new ByteSizeValue(this.total);
    }

    public ByteSizeValue getActive() {
        return new ByteSizeValue(this.active);
    }

    public short getActivePercent() {
        return FileCacheStats.calculatePercentage(this.active, this.used);
    }

    public ByteSizeValue getUsed() {
        return new ByteSizeValue(this.used);
    }

    public short getUsedPercent() {
        return FileCacheStats.calculatePercentage(this.getUsed().getBytes(), this.total);
    }

    public ByteSizeValue getEvicted() {
        return new ByteSizeValue(this.evicted);
    }

    public long getCacheHits() {
        return this.hits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("file_cache");
        builder.field("timestamp", this.getTimestamp());
        builder.humanReadableField("active_in_bytes", "active", this.getActive());
        builder.humanReadableField("total_in_bytes", "total", this.getTotal());
        builder.humanReadableField("used_in_bytes", "used", this.getUsed());
        builder.humanReadableField("evictions_in_bytes", "evictions", this.getEvicted());
        builder.field("active_percent", this.getActivePercent());
        builder.field("used_percent", this.getUsedPercent());
        builder.field("hit_count", this.getCacheHits());
        builder.field("miss_count", this.getCacheMisses());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String FILE_CACHE = "file_cache";
        static final String TIMESTAMP = "timestamp";
        static final String ACTIVE = "active";
        static final String ACTIVE_IN_BYTES = "active_in_bytes";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String EVICTIONS = "evictions";
        static final String EVICTIONS_IN_BYTES = "evictions_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String ACTIVE_PERCENT = "active_percent";
        static final String USED_PERCENT = "used_percent";
        static final String HIT_COUNT = "hit_count";
        static final String MISS_COUNT = "miss_count";

        Fields() {
        }
    }
}

