/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.EvaluationMetric;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.MetricDetail;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.RatedDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.RatedSearchHit;

public class EvalQueryQuality
implements ToXContentFragment,
Writeable {
    private final String queryId;
    private final double metricScore;
    private MetricDetail optionalMetricDetails;
    private final List<RatedSearchHit> ratedHits;
    static final ParseField METRIC_SCORE_FIELD = new ParseField("metric_score", new String[0]);
    private static final ParseField UNRATED_DOCS_FIELD = new ParseField("unrated_docs", new String[0]);
    private static final ParseField HITS_FIELD = new ParseField("hits", new String[0]);
    private static final ParseField METRIC_DETAILS_FIELD = new ParseField("metric_details", new String[0]);
    private static final ObjectParser<ParsedEvalQueryQuality, Void> PARSER = new ObjectParser("eval_query_quality", true, () -> new ParsedEvalQueryQuality());

    public EvalQueryQuality(String id, double metricScore) {
        this.queryId = id;
        this.metricScore = metricScore;
        this.ratedHits = new ArrayList<RatedSearchHit>();
    }

    public EvalQueryQuality(StreamInput in) throws IOException {
        this.queryId = in.readString();
        this.metricScore = in.readDouble();
        this.ratedHits = in.readList(RatedSearchHit::new);
        this.optionalMetricDetails = in.readOptionalNamedWriteable(MetricDetail.class);
    }

    private EvalQueryQuality(String queryId, ParsedEvalQueryQuality builder) {
        this.queryId = queryId;
        this.metricScore = builder.evaluationResult;
        this.optionalMetricDetails = builder.optionalMetricDetails;
        this.ratedHits = builder.ratedHits;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryId);
        out.writeDouble(this.metricScore);
        out.writeList(this.ratedHits);
        out.writeOptionalNamedWriteable(this.optionalMetricDetails);
    }

    public String getId() {
        return this.queryId;
    }

    public double metricScore() {
        return this.metricScore;
    }

    public void setMetricDetails(MetricDetail breakdown) {
        this.optionalMetricDetails = breakdown;
    }

    public MetricDetail getMetricDetails() {
        return this.optionalMetricDetails;
    }

    public void addHitsAndRatings(List<RatedSearchHit> hits) {
        this.ratedHits.addAll(hits);
    }

    public List<RatedSearchHit> getHitsAndRatings() {
        return this.ratedHits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.queryId);
        builder.field(METRIC_SCORE_FIELD.getPreferredName(), this.metricScore);
        builder.startArray(UNRATED_DOCS_FIELD.getPreferredName());
        for (RatedDocument.DocumentKey key : EvaluationMetric.filterUnratedDocuments(this.ratedHits)) {
            builder.startObject();
            builder.field(RatedDocument.INDEX_FIELD.getPreferredName(), key.getIndex());
            builder.field(RatedDocument.DOC_ID_FIELD.getPreferredName(), key.getDocId());
            builder.endObject();
        }
        builder.endArray();
        builder.startArray(HITS_FIELD.getPreferredName());
        for (RatedSearchHit hit : this.ratedHits) {
            hit.toXContent(builder, params);
        }
        builder.endArray();
        if (this.optionalMetricDetails != null) {
            builder.field(METRIC_DETAILS_FIELD.getPreferredName(), this.optionalMetricDetails);
        }
        builder.endObject();
        return builder;
    }

    private static MetricDetail parseMetricDetail(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        MetricDetail metricDetail = parser.namedObject(MetricDetail.class, parser.currentName(), null);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return metricDetail;
    }

    public static EvalQueryQuality fromXContent(XContentParser parser, String queryId) throws IOException {
        return new EvalQueryQuality(queryId, PARSER.apply(parser, null));
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EvalQueryQuality other = (EvalQueryQuality)obj;
        return Objects.equals(this.queryId, other.queryId) && Objects.equals(this.metricScore, other.metricScore) && Objects.equals(this.ratedHits, other.ratedHits) && Objects.equals(this.optionalMetricDetails, other.optionalMetricDetails);
    }

    public final int hashCode() {
        return Objects.hash(this.queryId, this.metricScore, this.ratedHits, this.optionalMetricDetails);
    }

    static {
        PARSER.declareDouble((obj, value) -> {
            obj.evaluationResult = value;
        }, METRIC_SCORE_FIELD);
        PARSER.declareObject((obj, value) -> {
            obj.optionalMetricDetails = value;
        }, (p, c) -> EvalQueryQuality.parseMetricDetail(p), METRIC_DETAILS_FIELD);
        PARSER.declareObjectArray((obj, list) -> {
            obj.ratedHits = list;
        }, (p, c) -> RatedSearchHit.parse(p), HITS_FIELD);
    }

    private static class ParsedEvalQueryQuality {
        double evaluationResult;
        MetricDetail optionalMetricDetails;
        List<RatedSearchHit> ratedHits = new ArrayList<RatedSearchHit>();

        private ParsedEvalQueryQuality() {
        }
    }
}

