/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.LatLonShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.LatLonGeometry;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Point;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoLineDecomposer;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPolygonDecomposer;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapeRelation;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Circle;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryCollection;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Line;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.LinearRing;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiLine;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPoint;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPolygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Polygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Rectangle;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;

public class VectorGeoShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(LegacyESVersion.V_7_5_0)) {
            throw new QueryShardException(context, String.valueOf(ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit(visitor);
        List<LatLonGeometry> geometries = visitor.geometries();
        if (geometries.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return LatLonShape.newGeometryQuery(fieldName, relation.getLuceneRelation(), geometries.toArray(new LatLonGeometry[geometries.size()]));
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<LatLonGeometry> geometries = new ArrayList<LatLonGeometry>();
        private final String name;
        private final QueryShardContext context;

        private LuceneGeometryCollector(String name, QueryShardContext context) {
            this.name = name;
            this.context = context;
        }

        List<LatLonGeometry> geometries() {
            return this.geometries;
        }

        @Override
        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add(GeoShapeUtils.toLuceneCircle(circle));
            }
            return null;
        }

        @Override
        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit(this);
            }
            return null;
        }

        @Override
        public Void visit(Line line) {
            if (!line.isEmpty()) {
                ArrayList<Line> collector = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, collector);
                this.collectLines(collector);
            }
            return null;
        }

        @Override
        public Void visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        @Override
        public Void visit(MultiLine multiLine) {
            ArrayList<Line> collector = new ArrayList<Line>();
            GeoLineDecomposer.decomposeMultiLine(multiLine, collector);
            this.collectLines(collector);
            return null;
        }

        @Override
        public Void visit(MultiPoint multiPoint) {
            for (org.graylog.shaded.opensearch2.org.opensearch.geometry.Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        @Override
        public Void visit(MultiPolygon multiPolygon) {
            if (!multiPolygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        @Override
        public Void visit(org.graylog.shaded.opensearch2.org.opensearch.geometry.Point point) {
            if (!point.isEmpty()) {
                double quantizedLat = GeoEncodingUtils.decodeLatitude(GeoEncodingUtils.encodeLatitude(point.getLat()));
                double quantizedLon = GeoEncodingUtils.decodeLongitude(GeoEncodingUtils.encodeLongitude(point.getLon()));
                this.geometries.add(new Point(quantizedLat, quantizedLon));
            }
            return null;
        }

        @Override
        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        @Override
        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add(GeoShapeUtils.toLuceneRectangle(r));
            }
            return null;
        }

        private void collectLines(List<Line> geometryLines) {
            for (Line line : geometryLines) {
                this.geometries.add(GeoShapeUtils.toLuceneLine(line));
            }
        }

        private void collectPolygons(List<Polygon> geometryPolygons) {
            for (Polygon polygon : geometryPolygons) {
                this.geometries.add(GeoShapeUtils.toLucenePolygon(polygon));
            }
        }
    }
}

