/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappingLookup;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.RootObjectMapper;

@PublicApi(since="1.0.0")
public final class Mapping
implements ToXContentFragment {
    final Version indexCreated;
    final RootObjectMapper root;
    final MetadataFieldMapper[] metadataMappers;
    final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    final Map<String, MetadataFieldMapper> metadataMappersByName;
    final Map<String, Object> meta;

    public Mapping(Version indexCreated, RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, Map<String, Object> meta) {
        this.indexCreated = indexCreated;
        this.metadataMappers = metadataMappers;
        HashMap metadataMappersMap = new HashMap();
        HashMap<String, MetadataFieldMapper> metadataMappersByName = new HashMap<String, MetadataFieldMapper>();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            metadataMappersMap.put(metadataMapper.getClass(), metadataMapper);
            metadataMappersByName.put(metadataMapper.name(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.metadataMappersMap = Collections.unmodifiableMap(metadataMappersMap);
        this.metadataMappersByName = Collections.unmodifiableMap(metadataMappersByName);
        this.meta = meta;
    }

    public RootObjectMapper root() {
        return this.root;
    }

    public void validate(MappingLookup mappers) {
        for (MetadataFieldMapper metadataFieldMapper : this.metadataMappers) {
            metadataFieldMapper.validate(mappers);
        }
        this.root.validate(mappers);
    }

    public Mapping mappingUpdate(Mapper rootObjectMapper) {
        return new Mapping(this.indexCreated, (RootObjectMapper)rootObjectMapper, this.metadataMappers, this.meta);
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    public Mapping merge(Mapping mergeWith, MapperService.MergeReason reason) {
        Map<String, Object> mergedMeta;
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root, reason);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetadataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetadataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null || reason == MapperService.MergeReason.INDEX_TEMPLATE ? metaMergeWith : (MetadataFieldMapper)mergeInto.merge(metaMergeWith);
            mergedMetadataMappers.put(merged.getClass(), merged);
        }
        if (mergeWith.meta == null) {
            mergedMeta = this.meta;
        } else if (this.meta == null || reason != MapperService.MergeReason.INDEX_TEMPLATE) {
            mergedMeta = mergeWith.meta;
        } else {
            mergedMeta = new HashMap<String, Object>(mergeWith.meta);
            XContentHelper.mergeDefaults(mergedMeta, this.meta);
        }
        return new Mapping(this.indexCreated, mergedRoot, mergedMetadataMappers.values().toArray(new MetadataFieldMapper[0]), mergedMeta);
    }

    public MetadataFieldMapper getMetadataMapper(String mapperName) {
        return this.metadataMappersByName.get(mapperName);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (Mapping.this.meta != null) {
                    builder.field("_meta", Mapping.this.meta);
                }
                for (MetadataFieldMapper mapper : Mapping.this.metadataMappers) {
                    mapper.toXContent(builder, params);
                }
                return builder;
            }
        });
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams(Collections.emptyMap()));
            return builder.endObject().toString();
        }
        catch (IOException bogus) {
            throw new UncheckedIOException(bogus);
        }
    }
}

