/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Iterators;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DynamicKeyFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DynamicKeyFieldTypeLookup;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldAliasMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;

@InternalApi
class FieldTypeLookup
implements Iterable<MappedFieldType> {
    private final Map<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
    private final Map<String, String> aliasToConcreteName = new HashMap<String, String>();
    private final Map<String, Set<String>> fieldToCopiedFields = new HashMap<String, Set<String>>();
    private final DynamicKeyFieldTypeLookup dynamicKeyLookup;

    FieldTypeLookup() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        HashMap<String, DynamicKeyFieldMapper> dynamicKeyMappers = new HashMap<String, DynamicKeyFieldMapper>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            this.fullNameToFieldType.put(fieldType.name(), fieldType);
            if (fieldMapper instanceof DynamicKeyFieldMapper) {
                dynamicKeyMappers.put(fieldName, (DynamicKeyFieldMapper)fieldMapper);
            }
            for (String targetField : fieldMapper.copyTo().copyToFields()) {
                Set<String> sourcePath = this.fieldToCopiedFields.get(targetField);
                if (sourcePath == null) {
                    HashSet<String> copiedFields = new HashSet<String>();
                    copiedFields.add(targetField);
                    this.fieldToCopiedFields.put(targetField, copiedFields);
                }
                this.fieldToCopiedFields.get(targetField).add(fieldName);
            }
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            this.aliasToConcreteName.put(aliasName, path);
        }
        this.dynamicKeyLookup = new DynamicKeyFieldTypeLookup(dynamicKeyMappers, this.aliasToConcreteName);
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        MappedFieldType fieldType = this.fullNameToFieldType.get(concreteField);
        if (fieldType != null) {
            return fieldType;
        }
        return this.dynamicKeyLookup.get(field);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    public Set<String> sourcePaths(String field) {
        String parentField;
        String resolvedField = field;
        int lastDotIndex = field.lastIndexOf(46);
        if (lastDotIndex > 0 && this.fullNameToFieldType.containsKey(parentField = field.substring(0, lastDotIndex))) {
            resolvedField = parentField;
        }
        return this.fieldToCopiedFields.containsKey(resolvedField) ? this.fieldToCopiedFields.get(resolvedField) : Set.of(resolvedField);
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        Iterator<MappedFieldType> concreteFieldTypes = this.fullNameToFieldType.values().iterator();
        Iterator<MappedFieldType> keyedFieldTypes = this.dynamicKeyLookup.fieldTypes();
        return Iterators.concat(concreteFieldTypes, keyedFieldTypes);
    }
}

