/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafFieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Pruning;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.comparators.DoubleComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.NumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.MultiValueMode;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.BucketedSort;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public class DoubleValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
        return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, double missingValue) throws IOException {
        SortedNumericDoubleValues values = this.getValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    protected void setScorer(Scorable scorer, LeafReaderContext context) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new DoubleComparator(numHits, fieldname, dMissingValue, reversed, this.filterPruning(pruning)){

            @Override
            public LeafFieldComparator getLeafComparator(final LeafReaderContext context) throws IOException {
                return new DoubleComparator.DoubleLeafComparator(context){

                    @Override
                    protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                        return DoubleValuesComparatorSource.this.getNumericDocValues(context2, dMissingValue).getRawDoubleValues();
                    }

                    @Override
                    public void setScorer(Scorable scorer) {
                        DoubleValuesComparatorSource.this.setScorer(scorer, context);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForDoubles(bigArrays, sortOrder, format, bucketSize, extra){
            private final double dMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.dMissingValue = (Double)DoubleValuesComparatorSource.this.missingObject(DoubleValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForDoubles.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForDoubles.Leaf(ctx){
                    private final NumericDoubleValues docValues;
                    private double docValue;
                    {
                        super(this, ctx2);
                        this.docValues = DoubleValuesComparatorSource.this.getNumericDocValues(ctx, dMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.doubleValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected double docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

