/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.identity.tokens;

import java.util.Collections;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.identity.tokens.AuthToken;
import org.graylog.shaded.opensearch2.org.opensearch.identity.tokens.BasicAuthToken;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;

public class RestTokenExtractor {
    private static final Logger logger = LogManager.getLogger(RestTokenExtractor.class);
    public static final String AUTH_HEADER_NAME = "Authorization";

    public static AuthToken extractToken(RestRequest request) {
        Optional authHeaderValue = request.getHeaders().getOrDefault(AUTH_HEADER_NAME, Collections.emptyList()).stream().findFirst();
        if (authHeaderValue.isPresent()) {
            String authHeaderValueStr = (String)authHeaderValue.get();
            if (authHeaderValueStr.startsWith("Basic")) {
                return new BasicAuthToken(authHeaderValueStr);
            }
            if (logger.isDebugEnabled()) {
                String tokenTypeTruncated = Strings.substring(authHeaderValueStr, 0, 5);
                logger.debug("An authentication header was detected but the token type was not supported " + tokenTypeTruncated);
            }
        }
        logger.trace("No auth token could be extracted");
        return null;
    }
}

