/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.gateway;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateApplier;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.InMemoryPersistedState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PersistedStateStats;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Manifest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.ClusterStateUpdaters;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.IncrementalClusterStateWriter;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.MetaStateService;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.PersistedClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.WriteStateException;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.remote.RemoteClusterStateService;
import org.graylog.shaded.opensearch2.org.opensearch.index.recovery.RemoteStoreRestoreService;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.MetadataUpgrader;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class GatewayMetaState
implements Closeable {
    public static final String STALE_STATE_CONFIG_NODE_ID = "STALE_STATE_CONFIG";
    private PersistedStateRegistry persistedStateRegistry;

    public CoordinationState.PersistedState getPersistedState() {
        CoordinationState.PersistedState persistedState = this.persistedStateRegistry.getPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL);
        assert (persistedState != null) : "not started";
        return persistedState;
    }

    public Metadata getMetadata() {
        return this.persistedStateRegistry.getPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL).getLastAcceptedState().metadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(Settings settings, TransportService transportService, ClusterService clusterService, MetaStateService metaStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader, PersistedClusterStateService persistedClusterStateService, RemoteClusterStateService remoteClusterStateService, PersistedStateRegistry persistedStateRegistry, RemoteStoreRestoreService remoteStoreRestoreService) {
        assert (this.persistedStateRegistry == null) : "Persisted state registry should only be set once";
        this.persistedStateRegistry = persistedStateRegistry;
        if (DiscoveryNode.isClusterManagerNode(settings) || DiscoveryNode.isDataNode(settings)) {
            try {
                void var17_23;
                PersistedClusterStateService.OnDiskState onDiskState = persistedClusterStateService.loadBestOnDiskState();
                Metadata metadata = onDiskState.metadata;
                long lastAcceptedVersion = onDiskState.lastAcceptedVersion;
                long currentTerm = onDiskState.currentTerm;
                if (onDiskState.empty()) {
                    assert (Version.CURRENT.major <= LegacyESVersion.V_7_0_0.major + 1) : "legacy metadata loader is not needed anymore from v9 onwards";
                    Tuple<Manifest, Metadata> tuple = metaStateService.loadFullState();
                    if (!tuple.v1().isEmpty()) {
                        metadata = tuple.v2();
                        lastAcceptedVersion = tuple.v1().getClusterStateVersion();
                        currentTerm = tuple.v1().getCurrentTerm();
                    }
                }
                Object var17_20 = null;
                RemotePersistedState remotePersistedState = null;
                boolean success = false;
                try {
                    ClusterState clusterState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).version(lastAcceptedVersion).metadata(metadata).build();
                    if (DiscoveryNode.isClusterManagerNode(settings) && RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(settings)) {
                        String lastKnownClusterUUID = "_na_";
                        if ("_na_".equals(clusterState.metadata().clusterUUID()) && !"_na_".equals(lastKnownClusterUUID = remoteClusterStateService.getLastKnownUUIDFromRemote(clusterState.getClusterName().value()))) {
                            RemoteStoreRestoreService.RemoteRestoreResult remoteRestoreResult = remoteStoreRestoreService.restore(ClusterState.builder(clusterState).metadata(Metadata.EMPTY_METADATA).build(), lastKnownClusterUUID, false, new String[0]);
                            clusterState = remoteRestoreResult.getClusterState();
                        }
                        remotePersistedState = new RemotePersistedState(remoteClusterStateService, lastKnownClusterUUID);
                    }
                    clusterState = this.prepareInitialClusterState(transportService, clusterService, ClusterState.builder(clusterState).metadata(this.upgradeMetadataForNode(clusterState.metadata(), metadataIndexUpgradeService, metadataUpgrader)).build());
                    if (DiscoveryNode.isClusterManagerNode(settings)) {
                        LucenePersistedState lucenePersistedState = new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState);
                    } else {
                        AsyncLucenePersistedState asyncLucenePersistedState = new AsyncLucenePersistedState(settings, transportService.getThreadPool(), new LucenePersistedState(persistedClusterStateService, currentTerm, clusterState));
                    }
                    if (DiscoveryNode.isDataNode(settings)) {
                        metaStateService.unreferenceAll();
                    } else {
                        metaStateService.deleteAll();
                    }
                    NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT), persistedClusterStateService.getDataPaths());
                    success = true;
                }
                finally {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable)persistedStateRegistry);
                    }
                }
                persistedStateRegistry.addPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL, (CoordinationState.PersistedState)var17_23);
                if (remotePersistedState == null) return;
                persistedStateRegistry.addPersistedState(PersistedStateRegistry.PersistedStateType.REMOTE, remotePersistedState);
                return;
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
        }
        long currentTerm = 0L;
        ClusterState clusterState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(settings)).build();
        if (persistedClusterStateService.getDataPaths().length > 0) {
            try (PersistedClusterStateService.Writer persistenceWriter = persistedClusterStateService.createWriter();){
                persistenceWriter.writeFullStateAndCommit(0L, clusterState);
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to load metadata", (Throwable)e, new Object[0]);
            }
            try {
                metaStateService.deleteAll();
                NodeMetadata.FORMAT.writeAndCleanup(new NodeMetadata(persistedClusterStateService.getNodeId(), Version.CURRENT), persistedClusterStateService.getDataPaths());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        persistedStateRegistry.addPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL, new InMemoryPersistedState(0L, clusterState));
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        assert (clusterState.nodes().getLocalNode() == null) : "prepareInitialClusterState must only be called once";
        assert (transportService.getLocalNode() != null) : "transport service is not yet started";
        return Function.identity().andThen(ClusterStateUpdaters::addStateNotRecoveredBlock).andThen(state -> ClusterStateUpdaters.setLocalNode(state, transportService.getLocalNode())).andThen(state -> ClusterStateUpdaters.upgradeAndArchiveUnknownOrInvalidSettings(state, clusterService.getClusterSettings())).andThen(ClusterStateUpdaters::recoverClusterBlocks).apply(clusterState);
    }

    Metadata upgradeMetadataForNode(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        return GatewayMetaState.upgradeMetadata(metadata, metadataIndexUpgradeService, metadataUpgrader);
    }

    static Metadata upgradeMetadata(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        boolean changed = false;
        Metadata.Builder upgradedMetadata = Metadata.builder(metadata);
        for (IndexMetadata indexMetadata : metadata) {
            IndexMetadata newMetadata;
            changed |= indexMetadata != (newMetadata = metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetadata.put(newMetadata, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metadata.getTemplates(), metadataUpgrader.indexTemplateMetadataUpgraders, upgradedMetadata::removeTemplate, (s, indexTemplateMetadata) -> upgradedMetadata.put((IndexTemplateMetadata)indexTemplateMetadata))) {
            changed = true;
        }
        return changed ? upgradedMetadata.build() : metadata;
    }

    private static boolean applyPluginUpgraders(Map<String, IndexTemplateMetadata> existingData, UnaryOperator<Map<String, IndexTemplateMetadata>> upgrader, Consumer<String> removeData, BiConsumer<String, IndexTemplateMetadata> putData) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (Map.Entry<String, IndexTemplateMetadata> customCursor : existingData.entrySet()) {
            existingMap.put(customCursor.getKey(), customCursor.getValue());
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), (IndexTemplateMetadata)upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.persistedStateRegistry);
    }

    public boolean allPendingAsyncStatesWritten() {
        CoordinationState.PersistedState ps = this.persistedStateRegistry.getPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL);
        if (ps instanceof AsyncLucenePersistedState) {
            return ((AsyncLucenePersistedState)ps).allPendingAsyncStatesWritten();
        }
        return true;
    }

    public static class RemotePersistedState
    implements CoordinationState.PersistedState {
        private static final Logger logger = LogManager.getLogger(RemotePersistedState.class);
        private ClusterState lastAcceptedState;
        private ClusterMetadataManifest lastAcceptedManifest;
        private final RemoteClusterStateService remoteClusterStateService;
        private String previousClusterUUID;

        public RemotePersistedState(RemoteClusterStateService remoteClusterStateService, String previousClusterUUID) {
            this.remoteClusterStateService = remoteClusterStateService;
            this.previousClusterUUID = previousClusterUUID;
        }

        @Override
        public long getCurrentTerm() {
            return this.lastAcceptedState != null ? this.lastAcceptedState.term() : 0L;
        }

        @Override
        public ClusterState getLastAcceptedState() {
            return this.lastAcceptedState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                ClusterMetadataManifest manifest;
                if (this.shouldWriteFullClusterState(clusterState)) {
                    Optional<ClusterMetadataManifest> latestManifest = this.remoteClusterStateService.getLatestClusterMetadataManifest(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID());
                    if (latestManifest.isPresent()) {
                        this.previousClusterUUID = latestManifest.get().getPreviousClusterUUID();
                    } else {
                        logger.error("Latest manifest is not present in remote store for cluster UUID: {}", (Object)clusterState.metadata().clusterUUID());
                    }
                    manifest = this.remoteClusterStateService.writeFullMetadata(clusterState, this.previousClusterUUID);
                } else {
                    assert (this.verifyManifestAndClusterState(this.lastAcceptedManifest, this.lastAcceptedState)) : "Previous manifest and previous ClusterState are not in sync";
                    manifest = this.remoteClusterStateService.writeIncrementalMetadata(this.lastAcceptedState, clusterState, this.lastAcceptedManifest);
                }
                assert (this.verifyManifestAndClusterState(manifest, clusterState)) : "Manifest and ClusterState are not in sync";
                this.lastAcceptedManifest = manifest;
                this.lastAcceptedState = clusterState;
            }
            catch (Exception e) {
                this.remoteClusterStateService.writeMetadataFailed();
                this.handleExceptionOnWrite(e);
            }
        }

        @Override
        public PersistedStateStats getStats() {
            return this.remoteClusterStateService.getStats();
        }

        private boolean verifyManifestAndClusterState(ClusterMetadataManifest manifest, ClusterState clusterState) {
            assert (manifest != null) : "ClusterMetadataManifest is null";
            assert (clusterState != null) : "ClusterState is null";
            assert (clusterState.metadata().indices().size() == manifest.getIndices().size()) : "Number of indices in last accepted state and manifest are different";
            manifest.getIndices().stream().forEach(md -> {
                assert (clusterState.metadata().indices().containsKey(md.getIndexName())) : "Last accepted state does not contain the index : " + md.getIndexName();
                assert (clusterState.metadata().indices().get(md.getIndexName()).getIndexUUID().equals(md.getIndexUUID())) : "Last accepted state and manifest do not have same UUID for index : " + md.getIndexName();
            });
            return true;
        }

        private boolean shouldWriteFullClusterState(ClusterState clusterState) {
            return this.lastAcceptedState == null || this.lastAcceptedManifest == null || this.lastAcceptedState.term() != clusterState.term() || this.lastAcceptedManifest.getOpensearchVersion() != Version.CURRENT;
        }

        @Override
        public void markLastAcceptedStateAsCommitted() {
            try {
                ClusterMetadataManifest committedManifest;
                assert (this.lastAcceptedState != null) : "Last accepted state is not present";
                assert (this.lastAcceptedManifest != null) : "Last accepted manifest is not present";
                ClusterState clusterState = this.lastAcceptedState;
                if (!this.lastAcceptedState.metadata().clusterUUID().equals("_na_") && !this.lastAcceptedState.metadata().clusterUUIDCommitted()) {
                    Metadata.Builder metadataBuilder = Metadata.builder(this.lastAcceptedState.metadata());
                    metadataBuilder.clusterUUIDCommitted(true);
                    clusterState = ClusterState.builder(this.lastAcceptedState).metadata(metadataBuilder).build();
                }
                this.lastAcceptedManifest = committedManifest = this.remoteClusterStateService.markLastStateAsCommitted(clusterState, this.lastAcceptedManifest);
                this.lastAcceptedState = clusterState;
            }
            catch (Exception e) {
                this.handleExceptionOnWrite(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.remoteClusterStateService.close();
        }

        private void handleExceptionOnWrite(Exception e) {
            throw ExceptionsHelper.convertToRuntime(e);
        }
    }

    static class LucenePersistedState
    implements CoordinationState.PersistedState {
        private long currentTerm;
        private ClusterState lastAcceptedState;
        private final PersistedClusterStateService persistedClusterStateService;
        private final AtomicReference<PersistedClusterStateService.Writer> persistenceWriter = new AtomicReference();
        boolean writeNextStateFully;

        LucenePersistedState(PersistedClusterStateService persistedClusterStateService, long currentTerm, ClusterState lastAcceptedState) throws IOException {
            this.persistedClusterStateService = persistedClusterStateService;
            this.currentTerm = currentTerm;
            this.lastAcceptedState = lastAcceptedState;
            PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();
            try {
                writer.writeFullStateAndCommit(currentTerm, lastAcceptedState);
            }
            catch (Exception e) {
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            this.persistenceWriter.set(writer);
        }

        @Override
        public long getCurrentTerm() {
            return this.currentTerm;
        }

        @Override
        public ClusterState getLastAcceptedState() {
            return this.lastAcceptedState;
        }

        @Override
        public void setCurrentTerm(long currentTerm) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(currentTerm, this.lastAcceptedState);
                    this.writeNextStateFully = false;
                } else {
                    this.getWriterSafe().writeIncrementalTermUpdateAndCommit(currentTerm, this.lastAcceptedState.version());
                }
            }
            catch (Exception e) {
                this.handleExceptionOnWrite(e);
            }
            this.currentTerm = currentTerm;
        }

        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            try {
                if (this.writeNextStateFully) {
                    this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                    this.writeNextStateFully = false;
                } else if (clusterState.term() != this.lastAcceptedState.term()) {
                    assert (clusterState.term() > this.lastAcceptedState.term()) : clusterState.term() + " vs " + this.lastAcceptedState.term();
                    this.getWriterSafe().writeFullStateAndCommit(this.currentTerm, clusterState);
                } else {
                    this.getWriterSafe().writeIncrementalStateAndCommit(this.currentTerm, this.lastAcceptedState, clusterState);
                }
            }
            catch (Exception e) {
                this.handleExceptionOnWrite(e);
            }
            this.lastAcceptedState = clusterState;
        }

        @Override
        public PersistedStateStats getStats() {
            return null;
        }

        private PersistedClusterStateService.Writer getWriterSafe() {
            PersistedClusterStateService.Writer writer = this.persistenceWriter.get();
            if (writer == null) {
                throw new AlreadyClosedException("persisted state has been closed");
            }
            if (writer.isOpen()) {
                return writer;
            }
            try {
                PersistedClusterStateService.Writer newWriter = this.persistedClusterStateService.createWriter();
                if (this.persistenceWriter.compareAndSet(writer, newWriter)) {
                    return newWriter;
                }
                assert (this.persistenceWriter.get() == null) : "expected no concurrent calls to getWriterSafe";
                newWriter.close();
                throw new AlreadyClosedException("persisted state has been closed");
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToRuntime(e);
            }
        }

        private void handleExceptionOnWrite(Exception e) {
            this.writeNextStateFully = true;
            throw ExceptionsHelper.convertToRuntime(e);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable)this.persistenceWriter.getAndSet(null));
        }
    }

    static class AsyncLucenePersistedState
    extends InMemoryPersistedState {
        private static final Logger logger = LogManager.getLogger(AsyncLucenePersistedState.class);
        static final String THREAD_NAME = "AsyncLucenePersistedState#updateTask";
        private final OpenSearchThreadPoolExecutor threadPoolExecutor;
        private final CoordinationState.PersistedState persistedState;
        boolean newCurrentTermQueued = false;
        boolean newStateQueued = false;
        private final Object mutex = new Object();
        static final CoordinationMetadata.VotingConfiguration staleStateConfiguration = new CoordinationMetadata.VotingConfiguration(Collections.singleton("STALE_STATE_CONFIG"));

        AsyncLucenePersistedState(Settings settings, ThreadPool threadPool, CoordinationState.PersistedState persistedState) {
            super(persistedState.getCurrentTerm(), persistedState.getLastAcceptedState());
            String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
            this.threadPoolExecutor = OpenSearchExecutors.newFixed(nodeName + "/AsyncLucenePersistedState#updateTask", 1, 1, OpenSearchExecutors.daemonThreadFactory(nodeName, THREAD_NAME), threadPool.getThreadContext());
            this.persistedState = persistedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCurrentTerm(long currentTerm) {
            Object object = this.mutex;
            synchronized (object) {
                super.setCurrentTerm(currentTerm);
                if (this.newCurrentTermQueued) {
                    logger.trace("term update already queued (setting term to {})", (Object)currentTerm);
                } else {
                    logger.trace("queuing term update (setting term to {})", (Object)currentTerm);
                    this.newCurrentTermQueued = true;
                    if (!this.newStateQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLastAcceptedState(ClusterState clusterState) {
            Object object = this.mutex;
            synchronized (object) {
                super.setLastAcceptedState(clusterState);
                if (this.newStateQueued) {
                    logger.trace("cluster state update already queued (setting cluster state to {})", (Object)clusterState.version());
                } else {
                    logger.trace("queuing cluster state update (setting cluster state to {})", (Object)clusterState.version());
                    this.newStateQueued = true;
                    if (!this.newCurrentTermQueued) {
                        this.scheduleUpdate();
                    }
                }
            }
        }

        private void scheduleUpdate() {
            assert (Thread.holdsLock(this.mutex));
            assert (this.threadPoolExecutor.getQueue().isEmpty()) : "threadPoolExecutor queue not empty";
            this.threadPoolExecutor.execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.error("Exception occurred when storing new meta data", (Throwable)e);
                }

                @Override
                public void onRejection(Exception e) {
                    assert (threadPoolExecutor.isShutdown()) : "only expect rejections when shutting down";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void doRun() {
                    ClusterState clusterState;
                    Long term;
                    Object object = mutex;
                    synchronized (object) {
                        if (newCurrentTermQueued) {
                            term = this.getCurrentTerm();
                            logger.trace("resetting newCurrentTermQueued");
                            newCurrentTermQueued = false;
                        } else {
                            term = null;
                        }
                        if (newStateQueued) {
                            clusterState = this.getLastAcceptedState();
                            logger.trace("resetting newStateQueued");
                            newStateQueued = false;
                        } else {
                            clusterState = null;
                        }
                    }
                    if (term != null) {
                        persistedState.setCurrentTerm(term);
                    }
                    if (clusterState != null) {
                        persistedState.setLastAcceptedState(AsyncLucenePersistedState.resetVotingConfiguration(clusterState));
                    }
                }
            });
        }

        static ClusterState resetVotingConfiguration(ClusterState clusterState) {
            CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(clusterState.coordinationMetadata()).lastAcceptedConfiguration(staleStateConfiguration).lastCommittedConfiguration(staleStateConfiguration).build();
            return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).coordinationMetadata(newCoordinationMetadata).build()).build();
        }

        @Override
        public void close() throws IOException {
            try {
                ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
            }
            finally {
                this.persistedState.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean allPendingAsyncStatesWritten() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.newCurrentTermQueued || this.newStateQueued) {
                    return false;
                }
                return this.threadPoolExecutor.getActiveCount() == 0;
            }
        }
    }

    private static class GatewayClusterApplier
    implements ClusterStateApplier {
        private static final Logger logger = LogManager.getLogger(GatewayClusterApplier.class);
        private final IncrementalClusterStateWriter incrementalClusterStateWriter;

        private GatewayClusterApplier(IncrementalClusterStateWriter incrementalClusterStateWriter) {
            this.incrementalClusterStateWriter = incrementalClusterStateWriter;
        }

        @Override
        public void applyClusterState(ClusterChangedEvent event) {
            if (event.state().blocks().disableStatePersistence()) {
                this.incrementalClusterStateWriter.setIncrementalWrite(false);
                return;
            }
            try {
                if (event.state().term() > this.incrementalClusterStateWriter.getPreviousManifest().getCurrentTerm()) {
                    this.incrementalClusterStateWriter.setCurrentTerm(event.state().term());
                }
                this.incrementalClusterStateWriter.updateClusterState(event.state());
                this.incrementalClusterStateWriter.setIncrementalWrite(true);
            }
            catch (WriteStateException e) {
                logger.warn("Exception occurred when storing new meta data", (Throwable)e);
            }
        }
    }
}

