/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.core.xcontent;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.Booleans;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public interface ToXContent {
    public static final Params EMPTY_PARAMS = new Params(){

        @Override
        public String param(String key) {
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            return defaultValue;
        }
    };

    public XContentBuilder toXContent(XContentBuilder var1, Params var2) throws IOException;

    default public boolean isFragment() {
        return true;
    }

    @PublicApi(since="1.0.0")
    public static interface Params {
        public String param(String var1);

        public String param(String var1, String var2);

        public boolean paramAsBoolean(String var1, boolean var2);

        public Boolean paramAsBoolean(String var1, Boolean var2);
    }

    public static class DelegatingMapParams
    extends MapParams {
        private final Params delegate;

        public DelegatingMapParams(Map<String, String> params, Params delegate) {
            super(params);
            this.delegate = delegate;
        }

        @Override
        public String param(String key) {
            return super.param(key, this.delegate.param(key));
        }

        @Override
        public String param(String key, String defaultValue) {
            return super.param(key, this.delegate.param(key, defaultValue));
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return super.paramAsBoolean(key, this.delegate.paramAsBoolean(key, defaultValue));
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            return super.paramAsBoolean(key, this.delegate.paramAsBoolean(key, defaultValue));
        }
    }

    public static class MapParams
    implements Params {
        private final Map<String, String> params;

        public MapParams(Map<String, String> params) {
            this.params = params;
        }

        @Override
        public String param(String key) {
            return this.params.get(key);
        }

        @Override
        public String param(String key, String defaultValue) {
            String value = this.params.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return Booleans.parseBoolean(this.param(key), defaultValue);
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            return Booleans.parseBoolean(this.param(key), defaultValue);
        }
    }
}

