/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.time;

import java.text.Format;
import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.OpenSearchDateTimePrinter;

class OpenSearchDateTimeFormatter
implements OpenSearchDateTimePrinter {
    private final DateTimeFormatter formatter;

    public OpenSearchDateTimeFormatter(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, Locale.ROOT);
    }

    public OpenSearchDateTimeFormatter(String pattern, Locale locale) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, locale);
    }

    public OpenSearchDateTimeFormatter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public OpenSearchDateTimeFormatter withLocale(Locale locale) {
        return new OpenSearchDateTimeFormatter(this.getFormatter().withLocale(locale));
    }

    @Override
    public OpenSearchDateTimeFormatter withZone(ZoneId zoneId) {
        return new OpenSearchDateTimeFormatter(this.getFormatter().withZone(zoneId));
    }

    @Override
    public String format(TemporalAccessor temporal) {
        return this.getFormatter().format(temporal);
    }

    public TemporalAccessor parse(CharSequence text, ParsePosition position) {
        return this.getFormatter().parse(text, position);
    }

    public TemporalAccessor parse(CharSequence text) {
        return this.getFormatter().parse(text);
    }

    public <T> T parse(CharSequence text, TemporalQuery<T> query) {
        return this.getFormatter().parse(text, query);
    }

    @Override
    public ZoneId getZone() {
        return this.getFormatter().getZone();
    }

    @Override
    public Locale getLocale() {
        return this.getFormatter().getLocale();
    }

    public TemporalAccessor parse(String input) {
        return this.formatter.parse(input);
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public Format toFormat() {
        return this.getFormatter().toFormat();
    }

    public Object parseObject(String text, ParsePosition pos) {
        return this.getFormatter().toFormat().parseObject(text, pos);
    }
}

