/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.round;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.round.Roundable;

@InternalApi
class BinarySearcher
implements Roundable {
    private final long[] values;
    private final int size;

    BinarySearcher(long[] values, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("at least one value must be present");
        }
        this.values = values;
        this.size = size;
    }

    @Override
    public long floor(long key) {
        int idx = Arrays.binarySearch(this.values, 0, this.size, key);
        assert (idx != -1) : "key must be greater than or equal to " + this.values[0];
        if (idx < 0) {
            idx = -2 - idx;
        }
        return this.values[idx];
    }
}

