/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.network;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.network.InetAddresses;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.PortsRange;

public final class NetworkAddress {
    private NetworkAddress() {
    }

    public static String format(InetAddress address) {
        return NetworkAddress.format(address, new PortsRange(""));
    }

    public static String format(InetSocketAddress address) {
        return NetworkAddress.format(address.getAddress(), address.getPort());
    }

    public static String format(InetAddress address, int port) {
        return NetworkAddress.format(address, new PortsRange(String.valueOf(port)));
    }

    public static String format(InetAddress address, PortsRange portsRange) {
        Objects.requireNonNull(address);
        StringBuilder builder = new StringBuilder();
        int numberOfPorts = portsRange.ports().length;
        if (numberOfPorts != 0 && address instanceof Inet6Address) {
            builder.append(InetAddresses.toUriString(address));
        } else {
            builder.append(InetAddresses.toAddrString(address));
        }
        if (numberOfPorts != 0) {
            builder.append(':');
            if (numberOfPorts == 1) {
                builder.append(portsRange.getPortRangeString());
            } else {
                builder.append("[").append(portsRange.getPortRangeString()).append("]");
            }
        }
        return builder.toString();
    }
}

