/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;

public class DiskIoBufferPool {
    public static final int BUFFER_SIZE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue(System.getProperty("opensearch.disk_io.direct.buffer.size", "64KB"), "opensearch.disk_io.direct.buffer.size").getBytes());
    public static final int HEAP_BUFFER_SIZE = 8192;
    private static final ThreadLocal<ByteBuffer> ioBufferPool = ThreadLocal.withInitial(() -> {
        if (DiskIoBufferPool.isWriteOrFlushThread()) {
            return ByteBuffer.allocateDirect(BUFFER_SIZE);
        }
        return ByteBuffer.allocate(8192);
    });

    public static ByteBuffer getIoBuffer() {
        ByteBuffer ioBuffer = ioBufferPool.get();
        ioBuffer.clear();
        return ioBuffer;
    }

    private static boolean isWriteOrFlushThread() {
        String threadName = Thread.currentThread().getName();
        for (String s : Arrays.asList("[write]", "[flush]", "[system_write]")) {
            if (!threadName.contains(s)) continue;
            return true;
        }
        return false;
    }
}

