/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.inject;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.ConstructionProxy;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.ConstructionProxyFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.spi.InjectionPoint;

class DefaultConstructionProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private final InjectionPoint injectionPoint;

    DefaultConstructionProxyFactory(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    @Override
    public ConstructionProxy<T> create() {
        final Constructor constructor = (Constructor)this.injectionPoint.getMember();
        return new ConstructionProxy<T>(){

            @Override
            public T newInstance(Object ... arguments) throws InvocationTargetException {
                try {
                    return constructor.newInstance(arguments);
                }
                catch (InstantiationException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError("Wrong access modifiers on " + String.valueOf(constructor), e);
                }
            }

            @Override
            public InjectionPoint getInjectionPoint() {
                return DefaultConstructionProxyFactory.this.injectionPoint;
            }

            @Override
            public Constructor<T> getConstructor() {
                return constructor;
            }
        };
    }
}

