/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.stream;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RateLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.common.StreamLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;

public class RateLimitingOffsetRangeInputStream
extends OffsetRangeInputStream {
    private final StreamLimiter streamLimiter;
    private final OffsetRangeInputStream delegate;

    public RateLimitingOffsetRangeInputStream(OffsetRangeInputStream delegate, Supplier<RateLimiter> rateLimiterSupplier, StreamLimiter.Listener listener) {
        this.streamLimiter = new StreamLimiter(rateLimiterSupplier, listener);
        this.delegate = delegate;
    }

    @Override
    public void setReadBlock(AtomicBoolean readBlock) {
        this.delegate.setReadBlock(readBlock);
    }

    @Override
    public int read() throws IOException {
        int b = this.delegate.read();
        this.streamLimiter.maybePause(1);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.delegate.read(b, off, len);
        if (n > 0) {
            this.streamLimiter.maybePause(n);
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.delegate.getFilePointer();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

