/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.blobstore;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.crypto.CryptoHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.crypto.EncryptedHeaderContentSupplier;

public class EncryptedBlobMetadata<T, U>
implements BlobMetadata {
    private final EncryptedHeaderContentSupplier encryptedHeaderContentSupplier;
    private final BlobMetadata delegate;
    private final CryptoHandler<T, U> cryptoHandler;

    public EncryptedBlobMetadata(BlobMetadata delegate, CryptoHandler<T, U> cryptoHandler, EncryptedHeaderContentSupplier encryptedHeaderContentSupplier) {
        this.encryptedHeaderContentSupplier = encryptedHeaderContentSupplier;
        this.delegate = delegate;
        this.cryptoHandler = cryptoHandler;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public long length() {
        U cryptoContext;
        try {
            cryptoContext = this.cryptoHandler.loadEncryptionMetadata(this.encryptedHeaderContentSupplier);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.cryptoHandler.estimateDecryptedLength(cryptoContext, this.delegate.length());
    }
}

