/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common;

import java.util.Base64;
import java.util.Random;
import org.graylog.shaded.opensearch2.org.opensearch.common.SecureRandomHolder;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDGenerator;

class RandomBasedUUIDGenerator
implements UUIDGenerator {
    RandomBasedUUIDGenerator() {
    }

    @Override
    public String getBase64UUID() {
        return this.getBase64UUID(SecureRandomHolder.INSTANCE);
    }

    public String getBase64UUID(Random random) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getUUIDBytes(random));
    }

    private byte[] getUUIDBytes(Random random) {
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return randomBytes;
    }
}

