/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PersistedStateStats;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="2.12.0")
public class ClusterStateStats
implements Writeable,
ToXContentObject {
    private AtomicLong updateSuccess = new AtomicLong(0L);
    private AtomicLong updateTotalTimeInMillis = new AtomicLong(0L);
    private AtomicLong updateFailed = new AtomicLong(0L);
    private List<PersistedStateStats> persistenceStats = new ArrayList<PersistedStateStats>();

    public ClusterStateStats() {
    }

    public long getUpdateSuccess() {
        return this.updateSuccess.get();
    }

    public long getUpdateTotalTimeInMillis() {
        return this.updateTotalTimeInMillis.get();
    }

    public long getUpdateFailed() {
        return this.updateFailed.get();
    }

    public List<PersistedStateStats> getPersistenceStats() {
        return this.persistenceStats;
    }

    public void stateUpdated() {
        this.updateSuccess.incrementAndGet();
    }

    public void stateUpdateFailed() {
        this.updateFailed.incrementAndGet();
    }

    public void stateUpdateTook(long stateUpdateTime) {
        this.updateTotalTimeInMillis.addAndGet(stateUpdateTime);
    }

    public ClusterStateStats setPersistenceStats(List<PersistedStateStats> persistenceStats) {
        this.persistenceStats = persistenceStats;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.updateSuccess.get());
        out.writeVLong(this.updateTotalTimeInMillis.get());
        out.writeVLong(this.updateFailed.get());
        out.writeVInt(this.persistenceStats.size());
        for (PersistedStateStats stats : this.persistenceStats) {
            stats.writeTo(out);
        }
    }

    public ClusterStateStats(StreamInput in) throws IOException {
        this.updateSuccess = new AtomicLong(in.readVLong());
        this.updateTotalTimeInMillis = new AtomicLong(in.readVLong());
        this.updateFailed = new AtomicLong(in.readVLong());
        int persistedStatsSize = in.readVInt();
        this.persistenceStats = new ArrayList<PersistedStateStats>();
        for (int statsNumber = 0; statsNumber < persistedStatsSize; ++statsNumber) {
            PersistedStateStats stats = new PersistedStateStats(in);
            this.persistenceStats.add(stats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("cluster_state_stats");
        builder.startObject("overall");
        builder.field("update_count", this.getUpdateSuccess());
        builder.field("total_time_in_millis", this.getUpdateTotalTimeInMillis());
        builder.field("failed_count", this.getUpdateFailed());
        builder.endObject();
        for (PersistedStateStats stats : this.persistenceStats) {
            stats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String CLUSTER_STATE_STATS = "cluster_state_stats";
        static final String OVERALL = "overall";
        static final String UPDATE_COUNT = "update_count";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String FAILED_COUNT = "failed_count";

        Fields() {
        }
    }
}

