/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.SystemIndices;

public class SystemIndexMetadataUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SystemIndexMetadataUpgradeService.class);
    private final SystemIndices systemIndices;
    private final ClusterService clusterService;
    private boolean clusterManager = false;
    private volatile Map<String, IndexMetadata> lastIndexMetadataMap = Map.of();
    private volatile boolean updateTaskPending = false;

    public SystemIndexMetadataUpgradeService(SystemIndices systemIndices, ClusterService clusterService) {
        this.systemIndices = systemIndices;
        this.clusterService = clusterService;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        Map<String, IndexMetadata> indexMetadataMap;
        if (event.localNodeClusterManager() != this.clusterManager) {
            this.clusterManager = event.localNodeClusterManager();
        }
        if (this.clusterManager && !this.updateTaskPending && this.lastIndexMetadataMap != (indexMetadataMap = event.state().metadata().indices())) {
            for (Map.Entry<String, IndexMetadata> cursor : indexMetadataMap.entrySet()) {
                if (cursor.getValue() == this.lastIndexMetadataMap.get(cursor.getKey()) || this.systemIndices.isSystemIndex(cursor.getValue().getIndex()) == cursor.getValue().isSystem()) continue;
                this.updateTaskPending = true;
                this.clusterService.submitStateUpdateTask("system_index_metadata_upgrade_service {system metadata change}", new SystemIndexMetadataUpdateTask());
                break;
            }
        }
    }

    public class SystemIndexMetadataUpdateTask
    extends ClusterStateUpdateTask {
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Map<String, IndexMetadata> indexMetadataMap = currentState.metadata().indices();
            ArrayList<IndexMetadata> updatedMetadata = new ArrayList<IndexMetadata>();
            for (Map.Entry<String, IndexMetadata> cursor : indexMetadataMap.entrySet()) {
                if (cursor.getValue() == SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap.get(cursor.getKey()) || SystemIndexMetadataUpgradeService.this.systemIndices.isSystemIndex(cursor.getValue().getIndex()) == cursor.getValue().isSystem()) continue;
                updatedMetadata.add(IndexMetadata.builder(cursor.getValue()).system(!cursor.getValue().isSystem()).build());
            }
            if (!updatedMetadata.isEmpty()) {
                Metadata.Builder builder = Metadata.builder(currentState.metadata());
                updatedMetadata.forEach(idxMeta -> builder.put((IndexMetadata)idxMeta, true));
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public void onFailure(String source, Exception e) {
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
            logger.error("failed to update system index metadata", (Throwable)e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            SystemIndexMetadataUpgradeService.this.lastIndexMetadataMap = newState.metadata().indices();
            SystemIndexMetadataUpgradeService.this.updateTaskPending = false;
        }
    }
}

