/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.BM25Similarity;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Similarity;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.TriFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.IndexScopedSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalyzerScope;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.IndexAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.NamedAnalyzer;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.similarity.SimilarityService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.SystemIndices;
import org.graylog.shaded.opensearch2.org.opensearch.indices.mapper.MapperRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;

public class MetadataIndexUpgradeService {
    private static final Logger logger = LogManager.getLogger(MetadataIndexUpgradeService.class);
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final MapperRegistry mapperRegistry;
    private final IndexScopedSettings indexScopedSettings;
    private final SystemIndices systemIndices;
    private final ScriptService scriptService;

    public MetadataIndexUpgradeService(Settings settings, NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, IndexScopedSettings indexScopedSettings, SystemIndices systemIndices, ScriptService scriptService) {
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.mapperRegistry = mapperRegistry;
        this.indexScopedSettings = indexScopedSettings;
        this.systemIndices = systemIndices;
        this.scriptService = scriptService;
    }

    public IndexMetadata upgradeIndexMetadata(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (this.isUpgraded(indexMetadata)) {
            return this.archiveBrokenIndexSettings(this.maybeMarkAsSystemIndex(indexMetadata));
        }
        this.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata metadataWithSystemMarked = this.maybeMarkAsSystemIndex(indexMetadata);
        IndexMetadata newMetadata = this.archiveBrokenIndexSettings(metadataWithSystemMarked);
        this.checkMappingsCompatibility(newMetadata);
        return this.markAsUpgraded(newMetadata);
    }

    boolean isUpgraded(IndexMetadata indexMetadata) {
        return indexMetadata.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN && !MetadataIndexUpgradeService.isSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion)) {
            if (minimumIndexCompatibilityVersion.equals(LegacyESVersion.V_7_0_0)) {
                throw new IllegalStateException("The index [" + String.valueOf(indexMetadata.getIndex()) + "] was created with version [" + String.valueOf(indexMetadata.getCreationVersion()) + "] but the minimum compatible version is OpenSearch 1.0.0 (or Elasticsearch 7.0.0). It should be re-indexed in OpenSearch 1.x (or Elasticsearch 7.x) before upgrading to " + String.valueOf(Version.CURRENT) + ".");
            }
            throw new IllegalStateException("The index [" + String.valueOf(indexMetadata.getIndex()) + "] was created with version [" + String.valueOf(indexMetadata.getCreationVersion()) + "] but the minimum compatible version is [" + String.valueOf(minimumIndexCompatibilityVersion) + "]. It should be re-indexed in OpenSearch " + minimumIndexCompatibilityVersion.major + ".x before upgrading to " + String.valueOf(Version.CURRENT) + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        return indexMetadata.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    private void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            IndexSettings indexSettings = new IndexSettings(indexMetadata, this.settings);
            AbstractMap<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarityMap = new AbstractMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>(){

                @Override
                public boolean containsKey(Object key) {
                    return true;
                }

                @Override
                public TriFunction<Settings, Version, ScriptService, Similarity> get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + String.valueOf(key.getClass());
                    return (settings, version, scriptService) -> new BM25Similarity();
                }

                @Override
                public Set<Map.Entry<String, TriFunction<Settings, Version, ScriptService, Similarity>>> entrySet() {
                    return Collections.emptySet();
                }
            };
            SimilarityService similarityService = new SimilarityService(indexSettings, null, (Map<String, TriFunction<Settings, Version, ScriptService, Similarity>>)similarityMap);
            final NamedAnalyzer fakeDefault = new NamedAnalyzer("default", AnalyzerScope.INDEX, new Analyzer(){

                @Override
                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    throw new UnsupportedOperationException("shouldn't be here");
                }
            });
            AbstractMap<String, NamedAnalyzer> analyzerMap = new AbstractMap<String, NamedAnalyzer>(){

                @Override
                public NamedAnalyzer get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + String.valueOf(key.getClass());
                    return new NamedAnalyzer((String)key, AnalyzerScope.INDEX, fakeDefault.analyzer());
                }

                @Override
                public Set<Map.Entry<String, NamedAnalyzer>> entrySet() {
                    return Collections.emptySet();
                }
            };
            try (IndexAnalyzers fakeIndexAnalzyers = new IndexAnalyzers((Map<String, NamedAnalyzer>)analyzerMap, (Map<String, NamedAnalyzer>)analyzerMap, (Map<String, NamedAnalyzer>)analyzerMap);){
                MapperService mapperService = new MapperService(indexSettings, fakeIndexAnalzyers, this.xContentRegistry, similarityService, this.mapperRegistry, () -> null, () -> false, this.scriptService);
                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + String.valueOf(indexMetadata.getIndex()) + "]", ex);
        }
    }

    private IndexMetadata markAsUpgraded(IndexMetadata indexMetadata) {
        Settings settings = Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetadata.builder(indexMetadata).settings(settings).build();
    }

    IndexMetadata archiveBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> logger.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> logger.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetadata.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetadata.builder(indexMetadata).settings(upgrade).build();
        }
        return indexMetadata;
    }

    IndexMetadata maybeMarkAsSystemIndex(IndexMetadata indexMetadata) {
        boolean isSystem = this.systemIndices.isSystemIndex(indexMetadata.getIndex());
        if (isSystem != indexMetadata.isSystem()) {
            return IndexMetadata.builder(indexMetadata).system(isSystem).build();
        }
        return indexMetadata;
    }
}

