/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AbstractNamedDiffable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.NamedDiff;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;

@PublicApi(since="1.0.0")
public class RestoreInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom,
Iterable<Entry> {
    public static final String BWC_UUID = new UUID(0L, 0L).toString();
    public static final String TYPE = "restore";
    public static final RestoreInProgress EMPTY = new RestoreInProgress(Map.of());
    private final Map<String, Entry> entries;

    private RestoreInProgress(Map<String, Entry> entries) {
        this.entries = Collections.unmodifiableMap(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entries.equals(((RestoreInProgress)o).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RestoreInProgress[");
        this.entries.forEach((? super K s, ? super V entry) -> builder.append("{").append((String)s).append("}{").append(entry.snapshot).append("},"));
        builder.setCharAt(builder.length() - 1, ']');
        return builder.toString();
    }

    public Entry get(String restoreUUID) {
        return this.entries.get(restoreUUID);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RestoreInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public RestoreInProgress(StreamInput in) throws IOException {
        int count = in.readVInt();
        HashMap<String, Entry> entriesBuilder = new HashMap<String, Entry>(count);
        for (int i = 0; i < count; ++i) {
            String uuid = in.readString();
            Snapshot snapshot = new Snapshot(in);
            State state = State.fromValue(in.readByte());
            List<String> indexBuilder = in.readStringList();
            entriesBuilder.put(uuid, new Entry(uuid, snapshot, state, Collections.unmodifiableList(indexBuilder), in.readMap(ShardId::new, ShardRestoreStatus::readShardRestoreStatus)));
        }
        this.entries = Collections.unmodifiableMap(entriesBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries.values()) {
            out.writeString(entry.uuid);
            entry.snapshot().writeTo(out);
            out.writeByte(entry.state().value());
            out.writeStringCollection(entry.indices);
            out.writeMap(entry.shards, (o, shardId) -> shardId.writeTo(o), (o, status) -> status.writeTo(o));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries.values()) {
            this.toXContent(entry, builder);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder) throws IOException {
        builder.startObject();
        builder.field("snapshot", entry.snapshot().getSnapshotId().getName());
        builder.field("repository", entry.snapshot().getRepository());
        builder.field("state", (Object)entry.state());
        builder.startArray("indices");
        for (String string : entry.indices()) {
            builder.value(string);
        }
        builder.endArray();
        builder.startArray("shards");
        for (Map.Entry entry2 : entry.shards.entrySet()) {
            ShardId shardId = (ShardId)entry2.getKey();
            ShardRestoreStatus status = (ShardRestoreStatus)entry2.getValue();
            builder.startObject();
            builder.field("index", shardId.getIndex());
            builder.field("shard", shardId.getId());
            builder.field("state", (Object)status.state());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    @PublicApi(since="1.0.0")
    public static class Entry {
        private final String uuid;
        private final State state;
        private final Snapshot snapshot;
        private final Map<ShardId, ShardRestoreStatus> shards;
        private final List<String> indices;

        public Entry(String uuid, Snapshot snapshot, State state, List<String> indices, Map<ShardId, ShardRestoreStatus> shards) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.state = Objects.requireNonNull(state);
            this.indices = Objects.requireNonNull(indices);
            this.shards = shards == null ? Map.of() : Collections.unmodifiableMap(shards);
            this.uuid = Objects.requireNonNull(uuid);
        }

        public String uuid() {
            return this.uuid;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public Map<ShardId, ShardRestoreStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<String> indices() {
            return this.indices;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.uuid.equals(entry.uuid) && this.snapshot.equals(entry.snapshot) && this.state == entry.state && this.indices.equals(entry.indices) && this.shards.equals(entry.shards);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.uuid, this.snapshot, this.state, this.indices, this.shards});
        }
    }

    @PublicApi(since="1.0.0")
    public static enum State {
        INIT(0),
        STARTED(1),
        SUCCESS(2),
        FAILURE(3);

        private final byte value;

        private State(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILURE;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILURE;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    @PublicApi(since="1.0.0")
    public static class ShardRestoreStatus
    implements Writeable {
        private State state;
        private String nodeId;
        private String reason;

        private ShardRestoreStatus() {
        }

        public ShardRestoreStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardRestoreStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardRestoreStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardRestoreStatus readShardRestoreStatus(StreamInput in) throws IOException {
            ShardRestoreStatus shardSnapshotStatus = new ShardRestoreStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardRestoreStatus status = (ShardRestoreStatus)o;
            return this.state == status.state && Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.nodeId, this.reason});
        }
    }

    public static final class Builder {
        private final Map<String, Entry> entries = new HashMap<String, Entry>();

        public Builder() {
        }

        public Builder(RestoreInProgress restoreInProgress) {
            this.entries.putAll(restoreInProgress.entries);
        }

        public Builder add(Entry entry) {
            this.entries.put(entry.uuid, entry);
            return this;
        }

        public RestoreInProgress build() {
            return this.entries.isEmpty() ? EMPTY : new RestoreInProgress(this.entries);
        }
    }
}

