/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.http.Header;
import org.graylog.shaded.opensearch2.org.apache.http.client.config.RequestConfig;
import org.graylog.shaded.opensearch2.org.apache.http.message.BasicHeader;
import org.graylog.shaded.opensearch2.org.opensearch.client.HttpAsyncResponseConsumerFactory;
import org.graylog.shaded.opensearch2.org.opensearch.client.WarningsHandler;

public final class RequestOptions {
    public static final RequestOptions DEFAULT = new Builder(Collections.emptyList(), HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory.DEFAULT, null, null).build();
    private final List<Header> headers;
    private final HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;
    private final WarningsHandler warningsHandler;
    private final RequestConfig requestConfig;

    private RequestOptions(Builder builder) {
        this.headers = Collections.unmodifiableList(new ArrayList(builder.headers));
        this.httpAsyncResponseConsumerFactory = builder.httpAsyncResponseConsumerFactory;
        this.warningsHandler = builder.warningsHandler;
        this.requestConfig = builder.requestConfig;
    }

    public Builder toBuilder() {
        return new Builder(this.headers, this.httpAsyncResponseConsumerFactory, this.warningsHandler, this.requestConfig);
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public HttpAsyncResponseConsumerFactory getHttpAsyncResponseConsumerFactory() {
        return this.httpAsyncResponseConsumerFactory;
    }

    public WarningsHandler getWarningsHandler() {
        return this.warningsHandler;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RequestOptions{");
        boolean comma = false;
        if (this.headers.size() > 0) {
            b.append("headers=");
            comma = true;
            for (int h = 0; h < this.headers.size(); ++h) {
                if (h != 0) {
                    b.append(',');
                }
                b.append(this.headers.get(h).toString());
            }
        }
        if (this.httpAsyncResponseConsumerFactory != HttpAsyncResponseConsumerFactory.DEFAULT) {
            if (comma) {
                b.append(", ");
            }
            comma = true;
            b.append("consumerFactory=").append(this.httpAsyncResponseConsumerFactory);
        }
        if (this.warningsHandler != null) {
            if (comma) {
                b.append(", ");
            }
            comma = true;
            b.append("warningsHandler=").append(this.warningsHandler);
        }
        return b.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RequestOptions other = (RequestOptions)obj;
        return this.headers.equals(other.headers) && this.httpAsyncResponseConsumerFactory.equals(other.httpAsyncResponseConsumerFactory) && Objects.equals(this.warningsHandler, other.warningsHandler);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.httpAsyncResponseConsumerFactory, this.warningsHandler);
    }

    public static class Builder {
        private final List<Header> headers;
        private HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;
        private WarningsHandler warningsHandler;
        private RequestConfig requestConfig;

        private Builder(List<Header> headers, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, WarningsHandler warningsHandler, RequestConfig requestConfig) {
            this.headers = new ArrayList<Header>(headers);
            this.httpAsyncResponseConsumerFactory = httpAsyncResponseConsumerFactory;
            this.warningsHandler = warningsHandler;
            this.requestConfig = requestConfig;
        }

        public RequestOptions build() {
            return new RequestOptions(this);
        }

        public Builder addHeader(String name, String value) {
            Objects.requireNonNull(name, "header name cannot be null");
            Objects.requireNonNull(value, "header value cannot be null");
            this.headers.add(new ReqHeader(name, value));
            return this;
        }

        public void setHttpAsyncResponseConsumerFactory(HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory) {
            this.httpAsyncResponseConsumerFactory = Objects.requireNonNull(httpAsyncResponseConsumerFactory, "httpAsyncResponseConsumerFactory cannot be null");
        }

        public void setWarningsHandler(WarningsHandler warningsHandler) {
            this.warningsHandler = warningsHandler;
        }

        public Builder setRequestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }
    }

    static final class ReqHeader
    extends BasicHeader {
        ReqHeader(String name, String value) {
            super(name, value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ReqHeader) {
                Header otherHeader = (Header)other;
                return Objects.equals(this.getName(), otherHeader.getName()) && Objects.equals(this.getValue(), otherHeader.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getValue());
        }
    }
}

