/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.joptsimple.OptionException;
import org.graylog.shaded.opensearch2.joptsimple.OptionParser;
import org.graylog.shaded.opensearch2.joptsimple.OptionSet;
import org.graylog.shaded.opensearch2.joptsimple.OptionSpec;
import org.graylog.shaded.opensearch2.org.opensearch.cli.SuppressForbidden;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cli.UserException;

public abstract class Command
implements Closeable {
    protected final String description;
    private final Runnable beforeMain;
    protected final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> helpOption = this.parser.acceptsAll(Arrays.asList("h", "help"), "Show help").forHelp();
    private final OptionSpec<Void> silentOption = this.parser.acceptsAll(Arrays.asList("s", "silent"), "Show minimal output");
    private final OptionSpec<Void> verboseOption = this.parser.acceptsAll(Arrays.asList("v", "verbose"), "Show verbose output").availableUnless(this.silentOption, new OptionSpec[0]);
    private Thread shutdownHookThread;

    public Command(String description, Runnable beforeMain) {
        this.description = description;
        this.beforeMain = beforeMain;
    }

    public final int main(String[] args, Terminal terminal) throws Exception {
        if (this.addShutdownHook()) {
            this.shutdownHookThread = new Thread(() -> {
                try {
                    this.close();
                }
                catch (IOException e) {
                    try (StringWriter sw = new StringWriter();
                         PrintWriter pw = new PrintWriter(sw);){
                        e.printStackTrace(pw);
                        terminal.errorPrintln(sw.toString());
                    }
                    catch (IOException impossible) {
                        throw new AssertionError((Object)impossible);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.beforeMain.run();
        try {
            this.mainWithoutErrorHandling(args, terminal);
        }
        catch (OptionException e) {
            this.printHelp(terminal, true);
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return 64;
        }
        catch (UserException e) {
            if (e.exitCode == 64) {
                this.printHelp(terminal, true);
            }
            if (e.getMessage() != null) {
                terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            }
            return e.exitCode;
        }
        return 0;
    }

    void mainWithoutErrorHandling(String[] args, Terminal terminal) throws Exception {
        OptionSet options = this.parser.parse(args);
        if (options.has(this.helpOption)) {
            this.printHelp(terminal, false);
            return;
        }
        if (options.has(this.silentOption)) {
            terminal.setVerbosity(Terminal.Verbosity.SILENT);
        } else if (options.has(this.verboseOption)) {
            terminal.setVerbosity(Terminal.Verbosity.VERBOSE);
        } else {
            terminal.setVerbosity(Terminal.Verbosity.NORMAL);
        }
        this.execute(terminal, options);
    }

    private void printHelp(Terminal terminal, boolean toStdError) throws IOException {
        if (toStdError) {
            terminal.errorPrintln(this.description);
            terminal.errorPrintln("");
            this.parser.printHelpOn(terminal.getErrorWriter());
        } else {
            terminal.println(this.description);
            terminal.println("");
            this.printAdditionalHelp(terminal);
            this.parser.printHelpOn(terminal.getWriter());
        }
    }

    protected void printAdditionalHelp(Terminal terminal) {
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    protected static void exit(int status) {
        System.exit(status);
    }

    protected abstract void execute(Terminal var1, OptionSet var2) throws Exception;

    protected boolean addShutdownHook() {
        return true;
    }

    Thread getShutdownHookThread() {
        return this.shutdownHookThread;
    }

    @Override
    public void close() throws IOException {
    }
}

