/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Constants;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.StringHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapCheck;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapChecks;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapContext;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapException;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapInfo;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapSettings;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.ConsoleCtrlHandler;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.JNAKernel32Library;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.JarHell;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.Natives;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.OpenSearchUncaughtExceptionHandler;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.Security;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.Spawner;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.StartupException;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cli.UserException;
import org.graylog.shaded.opensearch2.org.opensearch.common.PidFile;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.CreationException;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.LogConfigurator;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.network.IfConfig;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.SecureSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.settings.SecureString;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.transport.BoundTransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.JvmInfo;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.os.OsProbe;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.process.ProcessProbe;
import org.graylog.shaded.opensearch2.org.opensearch.node.InternalSettingsPreparer;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeValidationException;

final class Bootstrap {
    private static volatile Bootstrap INSTANCE;
    private volatile Node node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread;
    private final Spawner spawner = new Spawner();

    Bootstrap() {
        this.keepAliveThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Bootstrap.this.keepAliveLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "opensearch[keepAlive/" + String.valueOf(Version.CURRENT) + "]");
        this.keepAliveThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Bootstrap.this.keepAliveLatch.countDown();
            }
        });
    }

    public static void initializeNatives(Path tmpFile, boolean mlockAll, boolean systemCallFilter, boolean ctrlHandler) {
        final Logger logger = LogManager.getLogger(Bootstrap.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run opensearch as root");
        }
        if (systemCallFilter) {
            Natives.tryInstallSystemCallFilter(tmpFile);
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler(new ConsoleCtrlHandler(){

                @Override
                public boolean handle(int code) {
                    if (2 == code) {
                        logger.info("running graceful exit on windows");
                        try {
                            Bootstrap.stop();
                        }
                        catch (IOException e) {
                            throw new OpenSearchException("failed to stop node", (Throwable)e, new Object[0]);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
    }

    private void setup(boolean addShutdownHook, Environment environment) throws BootstrapException {
        Settings settings = environment.settings();
        try {
            this.spawner.spawnNativeControllers(environment, true);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        Bootstrap.initializeNatives(environment.tmpFile(), BootstrapSettings.MEMORY_LOCK_SETTING.get(settings), BootstrapSettings.SYSTEM_CALL_FILTER_SETTING.get(settings), BootstrapSettings.CTRLHANDLER_SETTING.get(settings));
        Bootstrap.initializeProbes();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        IOUtils.close(Bootstrap.this.node, Bootstrap.this.spawner);
                        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                        Configurator.shutdown((LoggerContext)context);
                        if (Bootstrap.this.node != null && !Bootstrap.this.node.awaitClose(10L, TimeUnit.SECONDS)) {
                            throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
                        }
                    }
                    catch (IOException ex) {
                        throw new OpenSearchException("failed to stop node", (Throwable)ex, new Object[0]);
                    }
                    catch (InterruptedException e) {
                        LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (IOException | URISyntaxException e) {
            throw new BootstrapException(e);
        }
        IfConfig.logIfNecessary();
        try {
            Security.configure(environment, BootstrapSettings.SECURITY_FILTER_BAD_DEFAULTS_SETTING.get(settings));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new BootstrapException(e);
        }
        this.node = new Node(environment){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BootstrapContext context, BoundTransportAddress boundTransportAddress, List<BootstrapCheck> checks) throws NodeValidationException {
                BootstrapChecks.check(context, boundTransportAddress, checks);
            }
        };
    }

    static SecureSettings loadSecureSettings(Environment initialEnv) throws BootstrapException {
        SecureString password;
        KeyStoreWrapper keystore;
        try {
            keystore = KeyStoreWrapper.load(initialEnv.configFile());
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        try {
            password = keystore != null && keystore.hasPassword() ? Bootstrap.readPassphrase(System.in, 128) : new SecureString(new char[0]);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        try {
            if (keystore == null) {
                KeyStoreWrapper keyStoreWrapper = KeyStoreWrapper.create();
                keyStoreWrapper.save(initialEnv.configFile(), new char[0]);
                KeyStoreWrapper keyStoreWrapper2 = keyStoreWrapper;
                return keyStoreWrapper2;
            }
            keystore.decrypt(password.getChars());
            KeyStoreWrapper.upgrade(keystore, initialEnv.configFile(), password.getChars());
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        finally {
            password.close();
        }
        return keystore;
    }

    static SecureString readPassphrase(InputStream stream, int maxLength) throws IOException {
        SecureString passphrase;
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            passphrase = new SecureString(Terminal.readLineToCharArray(reader, maxLength));
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Input exceeded maximum length")) {
                throw new IllegalStateException("Password exceeded maximum length of " + maxLength, e);
            }
            throw e;
        }
        if (passphrase.length() == 0) {
            passphrase.close();
            throw new IllegalStateException("Keystore passphrase required but none provided.");
        }
        return passphrase;
    }

    private static Environment createEnvironment(Path pidFile, SecureSettings secureSettings, Settings initialSettings, Path configPath) {
        Settings.Builder builder = Settings.builder();
        if (pidFile != null) {
            builder.put(Environment.NODE_PIDFILE_SETTING.getKey(), pidFile);
        }
        builder.put(initialSettings);
        if (secureSettings != null) {
            builder.setSecureSettings(secureSettings);
        }
        return InternalSettingsPreparer.prepareEnvironment(builder.build(), Collections.emptyMap(), configPath, () -> System.getenv("HOSTNAME"));
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    static void stop() throws IOException {
        try {
            IOUtils.close(Bootstrap.INSTANCE.node, Bootstrap.INSTANCE.spawner);
            if (Bootstrap.INSTANCE.node != null && !Bootstrap.INSTANCE.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (InterruptedException e) {
            LogManager.getLogger(Bootstrap.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            Bootstrap.INSTANCE.keepAliveLatch.countDown();
        }
    }

    static void init(boolean foreground, Path pidFile, boolean quiet, Environment initialEnv) throws BootstrapException, NodeValidationException, UserException {
        BootstrapInfo.init();
        INSTANCE = new Bootstrap();
        SecureSettings keystore = Bootstrap.loadSecureSettings(initialEnv);
        Environment environment = Bootstrap.createEnvironment(pidFile, keystore, initialEnv.settings(), initialEnv.configFile());
        LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(environment.settings()));
        try {
            LogConfigurator.configure(environment);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        if (environment.pidFile() != null) {
            try {
                PidFile.create(environment.pidFile(), true);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
        }
        boolean closeStandardStreams = !foreground || quiet;
        try {
            if (closeStandardStreams) {
                Logger rootLogger = LogManager.getRootLogger();
                Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
                if (maybeConsoleAppender != null) {
                    Loggers.removeAppender(rootLogger, maybeConsoleAppender);
                }
                Bootstrap.closeSystOut();
            }
            Bootstrap.checkLucene();
            Thread.setDefaultUncaughtExceptionHandler(new OpenSearchUncaughtExceptionHandler());
            INSTANCE.setup(true, environment);
            try {
                IOUtils.close((Closeable)keystore);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
            INSTANCE.start();
            if (!foreground) {
                Bootstrap.closeSysError();
            }
        }
        catch (RuntimeException | NodeValidationException e) {
            Logger rootLogger = LogManager.getRootLogger();
            Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
            if (foreground && maybeConsoleAppender != null) {
                Loggers.removeAppender(rootLogger, maybeConsoleAppender);
            }
            Logger logger = LogManager.getLogger(Bootstrap.class);
            if (e instanceof CreationException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = null;
                try {
                    ps = new PrintStream((OutputStream)os, false, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
                new StartupException(e).printStackTrace(ps);
                ps.flush();
                try {
                    logger.error("Guice Exception: {}", (Object)os.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                    e.addSuppressed(uee);
                }
            } else if (e instanceof NodeValidationException) {
                logger.error("node validation exception\n{}", (Object)e.getMessage());
            } else {
                logger.error("Exception", (Throwable)e);
            }
            if (foreground && maybeConsoleAppender != null) {
                Loggers.addAppender(rootLogger, maybeConsoleAppender);
            }
            throw e;
        }
    }

    @SuppressForbidden(reason="System#out")
    private static void closeSystOut() {
        System.out.close();
    }

    @SuppressForbidden(reason="System#err")
    private static void closeSysError() {
        System.err.close();
    }

    private static void checkLucene() {
        if (!Version.CURRENT.luceneVersion.equals(org.graylog.shaded.opensearch2.org.apache.lucene.util.Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of OpenSearch requires lucene version [" + String.valueOf(Version.CURRENT.luceneVersion) + "]  but the current lucene version is [" + String.valueOf(org.graylog.shaded.opensearch2.org.apache.lucene.util.Version.LATEST) + "]"));
        }
    }
}

