/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

public abstract class ClusterManagerNodeRequest<Request extends ClusterManagerNodeRequest<Request>>
extends ActionRequest {
    public static final TimeValue DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
    @Deprecated
    public static final TimeValue DEFAULT_MASTER_NODE_TIMEOUT;
    protected TimeValue clusterManagerNodeTimeout;
    @Deprecated
    protected TimeValue masterNodeTimeout;

    protected ClusterManagerNodeRequest() {
        this.masterNodeTimeout = this.clusterManagerNodeTimeout = DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
    }

    protected ClusterManagerNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.masterNodeTimeout = this.clusterManagerNodeTimeout = DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT;
        this.clusterManagerNodeTimeout = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeTimeValue(this.clusterManagerNodeTimeout);
    }

    public final Request clusterManagerNodeTimeout(TimeValue timeout) {
        this.clusterManagerNodeTimeout = timeout;
        return (Request)this;
    }

    @Deprecated
    public final Request masterNodeTimeout(TimeValue timeout) {
        return this.clusterManagerNodeTimeout(timeout);
    }

    public final Request clusterManagerNodeTimeout(String timeout) {
        return this.clusterManagerNodeTimeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".clusterManagerNodeTimeout"));
    }

    @Deprecated
    public final Request masterNodeTimeout(String timeout) {
        return this.clusterManagerNodeTimeout(timeout);
    }

    public final TimeValue clusterManagerNodeTimeout() {
        return this.clusterManagerNodeTimeout;
    }

    @Deprecated
    public final TimeValue masterNodeTimeout() {
        return this.clusterManagerNodeTimeout();
    }

    static {
        DEFAULT_MASTER_NODE_TIMEOUT = DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT = TimeValue.timeValueSeconds(30L);
    }
}

