/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support;

import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.common.Booleans;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.SystemIndices;

public final class AutoCreateIndex {
    public static final Setting<AutoCreate> AUTO_CREATE_INDEX_SETTING = new Setting<AutoCreate>("action.auto_create_index", "true", x$0 -> new AutoCreate((String)x$0), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final boolean dynamicMappingDisabled;
    private final IndexNameExpressionResolver resolver;
    private final SystemIndices systemIndices;
    private volatile AutoCreate autoCreate;

    public AutoCreateIndex(Settings settings, ClusterSettings clusterSettings, IndexNameExpressionResolver resolver, SystemIndices systemIndices) {
        this.resolver = resolver;
        this.dynamicMappingDisabled = MapperService.INDEX_MAPPER_DYNAMIC_SETTING.get(settings) == false;
        this.systemIndices = systemIndices;
        this.autoCreate = AUTO_CREATE_INDEX_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AUTO_CREATE_INDEX_SETTING, this::setAutoCreate);
    }

    public boolean needToCheck() {
        return this.autoCreate.autoCreateIndex;
    }

    public boolean shouldAutoCreate(String index, ClusterState state) {
        if (this.resolver.hasIndexAbstraction(index, state)) {
            return false;
        }
        if (this.systemIndices.isSystemIndex(index)) {
            return true;
        }
        AutoCreate autoCreate = this.autoCreate;
        if (!autoCreate.autoCreateIndex) {
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] is [false]", index);
        }
        if (this.dynamicMappingDisabled) {
            throw new IndexNotFoundException("[" + MapperService.INDEX_MAPPER_DYNAMIC_SETTING.getKey() + "] is [false]", index);
        }
        if (autoCreate.expressions.isEmpty()) {
            return true;
        }
        for (Tuple<String, Boolean> expression : autoCreate.expressions) {
            String indexExpression = expression.v1();
            boolean include = expression.v2();
            if (!Regex.simpleMatch(indexExpression, index)) continue;
            if (include) {
                return true;
            }
            throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] contains [-" + indexExpression + "] which forbids automatic creation of the index", index);
        }
        throw new IndexNotFoundException("[" + AUTO_CREATE_INDEX_SETTING.getKey() + "] ([" + String.valueOf(autoCreate) + "]) doesn't match", index);
    }

    AutoCreate getAutoCreate() {
        return this.autoCreate;
    }

    void setAutoCreate(AutoCreate autoCreate) {
        this.autoCreate = autoCreate;
    }

    static class AutoCreate {
        private final boolean autoCreateIndex;
        private final List<Tuple<String, Boolean>> expressions;
        private final String string;

        private AutoCreate(String value) {
            boolean autoCreateIndex;
            ArrayList<Tuple<String, Boolean>> expressions = new ArrayList<Tuple<String, Boolean>>();
            try {
                autoCreateIndex = Booleans.parseBoolean(value);
            }
            catch (IllegalArgumentException ex) {
                try {
                    String[] patterns;
                    for (String pattern : patterns = Strings.commaDelimitedListToStringArray(value)) {
                        Tuple<String, Boolean> expression;
                        if (pattern == null || pattern.trim().length() == 0) {
                            throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must be either [true, false, or a comma separated list of index patterns]");
                        }
                        if ((pattern = pattern.trim()).startsWith("-")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [-]");
                            }
                            expression = new Tuple<String, Boolean>(pattern.substring(1), false);
                        } else if (pattern.startsWith("+")) {
                            if (pattern.length() == 1) {
                                throw new IllegalArgumentException("Can't parse [" + value + "] for setting [action.auto_create_index] must contain an index name after [+]");
                            }
                            expression = new Tuple<String, Boolean>(pattern.substring(1), true);
                        } else {
                            expression = new Tuple<String, Boolean>(pattern, true);
                        }
                        expressions.add(expression);
                    }
                    autoCreateIndex = true;
                }
                catch (IllegalArgumentException ex1) {
                    ex1.addSuppressed(ex);
                    throw ex1;
                }
            }
            this.expressions = expressions;
            this.autoCreateIndex = autoCreateIndex;
            this.string = value;
        }

        boolean isAutoCreateIndex() {
            return this.autoCreateIndex;
        }

        List<Tuple<String, Boolean>> getExpressions() {
            return this.expressions;
        }

        public String toString() {
            return this.string;
        }
    }
}

