/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeletePitResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.PitSearchContextIdForNode;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.PitService;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchContextId;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchContextIdForNode;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.HandledTransportAction;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportDeletePitAction
extends HandledTransportAction<DeletePitRequest, DeletePitResponse> {
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final PitService pitService;

    @Inject
    public TransportDeletePitAction(TransportService transportService, ActionFilters actionFilters, NamedWriteableRegistry namedWriteableRegistry, PitService pitService) {
        super("indices:data/read/point_in_time/delete", transportService, actionFilters, DeletePitRequest::new);
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.pitService = pitService;
    }

    @Override
    protected void doExecute(Task task, DeletePitRequest request, ActionListener<DeletePitResponse> listener) {
        if (request.getPitIds().size() == 1 && "_all".equals(request.getPitIds().get(0))) {
            this.deleteAllPits(listener);
        } else {
            this.deletePits(listener, request);
        }
    }

    private void deletePits(ActionListener<DeletePitResponse> listener, DeletePitRequest request) {
        HashMap<String, List<PitSearchContextIdForNode>> nodeToContextsMap = new HashMap<String, List<PitSearchContextIdForNode>>();
        LinkedHashSet<String> uniquePitIds = new LinkedHashSet<String>(request.getPitIds());
        for (String pitId : uniquePitIds) {
            SearchContextId contextId = SearchContextId.decode(this.namedWriteableRegistry, pitId);
            for (SearchContextIdForNode contextIdForNode : contextId.shards().values()) {
                PitSearchContextIdForNode pitSearchContext = new PitSearchContextIdForNode(pitId, contextIdForNode);
                List contexts = nodeToContextsMap.getOrDefault(contextIdForNode.getNode(), new ArrayList());
                contexts.add(pitSearchContext);
                nodeToContextsMap.put(contextIdForNode.getNode(), contexts);
            }
        }
        this.pitService.deletePitContexts(nodeToContextsMap, listener);
    }

    private void deleteAllPits(ActionListener<DeletePitResponse> listener) {
        this.pitService.getAllPits(ActionListener.wrap(getAllPitNodesResponse -> {
            DeletePitRequest deletePitRequest = new DeletePitRequest(getAllPitNodesResponse.getPitInfos().stream().map(r -> r.getPitId()).collect(Collectors.toList()));
            this.deletePits(listener, deletePitRequest);
        }, listener::onFailure));
    }
}

