/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseName;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestOperationsListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.CounterMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.MeanMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;

@PublicApi(since="2.11.0")
public final class SearchRequestStats
extends SearchRequestOperationsListener {
    Map<SearchPhaseName, StatsHolder> phaseStatsMap = new EnumMap<SearchPhaseName, StatsHolder>(SearchPhaseName.class);
    public static final String SEARCH_REQUEST_STATS_ENABLED_KEY = "search.request_stats_enabled";
    public static final Setting<Boolean> SEARCH_REQUEST_STATS_ENABLED = Setting.boolSetting("search.request_stats_enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);

    @Inject
    public SearchRequestStats(ClusterSettings clusterSettings) {
        this.setEnabled(clusterSettings.get(SEARCH_REQUEST_STATS_ENABLED));
        clusterSettings.addSettingsUpdateConsumer(SEARCH_REQUEST_STATS_ENABLED, this::setEnabled);
        for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
            this.phaseStatsMap.put(searchPhaseName, new StatsHolder());
        }
    }

    public long getPhaseCurrent(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).current.count();
    }

    public long getPhaseTotal(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).total.count();
    }

    public long getPhaseMetric(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).timing.sum();
    }

    @Override
    protected void onPhaseStart(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.inc();
    }

    @Override
    protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        StatsHolder phaseStats = this.phaseStatsMap.get((Object)context.getCurrentPhase().getSearchPhaseName());
        phaseStats.current.dec();
        phaseStats.total.inc();
        phaseStats.timing.inc(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.getCurrentPhase().getStartTimeInNanos()));
    }

    @Override
    protected void onPhaseFailure(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.dec();
    }

    public static final class StatsHolder {
        CounterMetric current = new CounterMetric();
        CounterMetric total = new CounterMetric();
        MeanMetric timing = new MeanMetric();
    }
}

