/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;

@InternalApi
public abstract class SearchRequestOperationsListener {
    private volatile boolean enabled;

    protected SearchRequestOperationsListener() {
        this.enabled = true;
    }

    protected SearchRequestOperationsListener(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void onPhaseStart(SearchPhaseContext var1);

    protected abstract void onPhaseEnd(SearchPhaseContext var1, SearchRequestContext var2);

    protected abstract void onPhaseFailure(SearchPhaseContext var1);

    protected void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    protected void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    protected boolean isEnabled(SearchRequest searchRequest) {
        return this.isEnabled();
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static final class CompositeListener
    extends SearchRequestOperationsListener {
        private final List<SearchRequestOperationsListener> listeners;
        private final Logger logger;

        CompositeListener(List<SearchRequestOperationsListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        protected void onPhaseStart(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseStart(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseStart listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseEnd(context, searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseEnd listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onPhaseFailure(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseFailure(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseFailure listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onRequestStart(SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onRequestStart(searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onRequestStart listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onRequestEnd(context, searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onRequestEnd listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        public List<SearchRequestOperationsListener> getListeners() {
            return this.listeners;
        }
    }
}

