/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestOperationsListener;

public final class SearchRequestOperationsCompositeListenerFactory {
    private final List<SearchRequestOperationsListener> searchRequestListenersList = new ArrayList<SearchRequestOperationsListener>();

    public SearchRequestOperationsCompositeListenerFactory(SearchRequestOperationsListener ... listeners) {
        for (SearchRequestOperationsListener listener : listeners) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.searchRequestListenersList.add(listener);
        }
    }

    public List<SearchRequestOperationsListener> getListeners() {
        return this.searchRequestListenersList;
    }

    public SearchRequestOperationsListener.CompositeListener buildCompositeListener(SearchRequest searchRequest, Logger logger, SearchRequestOperationsListener ... perRequestListeners) {
        List<SearchRequestOperationsListener> searchListenersList = Stream.concat(this.searchRequestListenersList.stream(), Arrays.stream(perRequestListeners)).filter(searchRequestOperationsListener -> searchRequestOperationsListener.isEnabled(searchRequest)).collect(Collectors.toList());
        return new SearchRequestOperationsListener.CompositeListener(searchListenersList, logger);
    }
}

