/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;

@PublicApi(since="2.9.0")
public enum SearchPhaseName {
    DFS_PRE_QUERY("dfs_pre_query"),
    QUERY("query"),
    FETCH("fetch"),
    DFS_QUERY("dfs_query"),
    EXPAND("expand"),
    CAN_MATCH("can_match");

    private final String name;
    private static final Set<String> PHASE_NAMES;

    private SearchPhaseName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isValidName(String phaseName) {
        return PHASE_NAMES.contains(phaseName);
    }

    static {
        PHASE_NAMES = new HashSet<String>();
        for (SearchPhaseName phaseName : SearchPhaseName.values()) {
            PHASE_NAMES.add(phaseName.name);
        }
    }
}

