/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.GetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetItemResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.get.GetResult;

@PublicApi(since="1.0.0")
public class MultiGetResponse
extends ActionResponse
implements Iterable<MultiGetItemResponse>,
ToXContentObject {
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ERROR = new ParseField("error", new String[0]);
    private static final ParseField DOCS = new ParseField("docs", new String[0]);
    @Deprecated(forRemoval=true)
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private final MultiGetItemResponse[] responses;

    public MultiGetResponse(MultiGetItemResponse[] responses) {
        this.responses = responses;
    }

    MultiGetResponse(StreamInput in) throws IOException {
        super(in);
        this.responses = in.readArray(MultiGetItemResponse::new, MultiGetItemResponse[]::new);
    }

    public MultiGetItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiGetItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(DOCS.getPreferredName());
        for (MultiGetItemResponse response : this.responses) {
            if (response.isFailed()) {
                Failure failure = response.getFailure();
                failure.toXContent(builder, params);
                continue;
            }
            GetResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiGetResponse fromXContent(XContentParser parser) throws IOException {
        String currentFieldName = null;
        ArrayList<MultiGetItemResponse> items = new ArrayList<MultiGetItemResponse>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    break;
                }
                case START_ARRAY: {
                    if (!DOCS.getPreferredName().equals(currentFieldName)) break;
                    token = parser.nextToken();
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            items.add(MultiGetResponse.parseItem(parser));
                        }
                        token = parser.nextToken();
                    }
                    break;
                }
            }
            token = parser.nextToken();
        }
        return new MultiGetResponse(items.toArray(new MultiGetItemResponse[0]));
    }

    private static MultiGetItemResponse parseItem(XContentParser parser) throws IOException {
        String currentFieldName = null;
        String index = null;
        String id = null;
        OpenSearchException exception = null;
        GetResult getResult = null;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    if (INDEX.match(currentFieldName, parser.getDeprecationHandler()) || ID.match(currentFieldName, parser.getDeprecationHandler()) || TYPE.match(currentFieldName, parser.getDeprecationHandler()) || ERROR.match(currentFieldName, parser.getDeprecationHandler())) break;
                    getResult = GetResult.fromXContentEmbedded(parser, index, id);
                    break;
                }
                case VALUE_STRING: {
                    if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                        index = parser.text();
                        break;
                    }
                    if (!ID.match(currentFieldName, parser.getDeprecationHandler())) break;
                    id = parser.text();
                    break;
                }
                case START_OBJECT: {
                    if (!ERROR.match(currentFieldName, parser.getDeprecationHandler())) break;
                    exception = OpenSearchException.fromXContent(parser);
                    break;
                }
            }
            if (getResult != null) break;
            token = parser.nextToken();
        }
        if (exception != null) {
            return new MultiGetItemResponse(null, new Failure(index, id, exception));
        }
        GetResponse getResponse = new GetResponse(getResult);
        return new MultiGetItemResponse(getResponse, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(this.responses);
    }

    @PublicApi(since="1.0.0")
    public static class Failure
    implements Writeable,
    ToXContentObject {
        private final String index;
        private final String id;
        private final Exception exception;

        public Failure(String index, String id, Exception exception) {
            this.index = index;
            this.id = id;
            this.exception = exception;
        }

        Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                in.readOptionalString();
            }
            this.id = in.readString();
            this.exception = in.readException();
        }

        public String getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.exception != null ? this.exception.getMessage() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeOptionalString("_doc");
            }
            out.writeString(this.id);
            out.writeException(this.exception);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX.getPreferredName(), this.index);
            builder.field(ID.getPreferredName(), this.id);
            OpenSearchException.generateFailureXContent(builder, params, this.exception, true);
            builder.endObject();
            return builder;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

