/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.find;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.find.NodeFindDanglingIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.DanglingIndicesState;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportFindDanglingIndexAction
extends TransportNodesAction<FindDanglingIndexRequest, FindDanglingIndexResponse, NodeFindDanglingIndexRequest, NodeFindDanglingIndexResponse> {
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportFindDanglingIndexAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super("cluster:admin/indices/dangling/find", threadPool, clusterService, transportService, actionFilters, FindDanglingIndexRequest::new, NodeFindDanglingIndexRequest::new, "management", NodeFindDanglingIndexResponse.class);
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected FindDanglingIndexResponse newResponse(FindDanglingIndexRequest request, List<NodeFindDanglingIndexResponse> nodeResponses, List<FailedNodeException> failures) {
        return new FindDanglingIndexResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    @Override
    protected NodeFindDanglingIndexRequest newNodeRequest(FindDanglingIndexRequest request) {
        return new NodeFindDanglingIndexRequest(request.getIndexUUID());
    }

    @Override
    protected NodeFindDanglingIndexResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodeFindDanglingIndexResponse(in);
    }

    @Override
    protected NodeFindDanglingIndexResponse nodeOperation(NodeFindDanglingIndexRequest request) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        String indexUUID = request.getIndexUUID();
        ArrayList<IndexMetadata> danglingIndexInfo = new ArrayList<IndexMetadata>();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (!each.getIndexUUID().equals(indexUUID)) continue;
            danglingIndexInfo.add(each);
        }
        return new NodeFindDanglingIndexResponse(localNode, danglingIndexInfo);
    }
}

