/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.fst;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ByteBlockPool;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.ByteBlockPoolReverseBytesReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.FST;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.fst.FSTCompiler;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.packed.PackedInts;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.packed.PagedGrowableWriter;

final class NodeHash<T> {
    private PagedGrowableHash primaryTable;
    private final long ramLimitBytes;
    private PagedGrowableHash fallbackTable;
    private final FSTCompiler<T> fstCompiler;
    private final FST.Arc<T> scratchArc = new FST.Arc();
    private int lastFallbackNodeLength;
    private long lastFallbackHashSlot;

    public NodeHash(FSTCompiler<T> fstCompiler, double ramLimitMB) {
        if (ramLimitMB <= 0.0) {
            throw new IllegalArgumentException("ramLimitMB must be > 0; got: " + ramLimitMB);
        }
        double asBytes = ramLimitMB * 1024.0 * 1024.0;
        this.ramLimitBytes = asBytes >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)asBytes;
        this.primaryTable = new PagedGrowableHash();
        this.fstCompiler = fstCompiler;
    }

    private long getFallback(FSTCompiler.UnCompiledNode<T> nodeIn, long hash) throws IOException {
        this.lastFallbackNodeLength = -1;
        this.lastFallbackHashSlot = -1L;
        if (this.fallbackTable == null) {
            return 0L;
        }
        long hashSlot = hash & this.fallbackTable.mask;
        int c = 0;
        long nodeAddress;
        while ((nodeAddress = this.fallbackTable.getNodeAddress(hashSlot)) != 0L) {
            int length = this.fallbackTable.nodesEqual(nodeIn, nodeAddress, hashSlot);
            if (length != -1) {
                this.lastFallbackNodeLength = length;
                this.lastFallbackHashSlot = hashSlot;
                return nodeAddress;
            }
            hashSlot = hashSlot + (long)(++c) & this.fallbackTable.mask;
        }
        return 0L;
    }

    public long add(FSTCompiler.UnCompiledNode<T> nodeIn) throws IOException {
        long hash = this.hash(nodeIn);
        long hashSlot = hash & this.primaryTable.mask;
        int c = 0;
        while (true) {
            long nodeAddress;
            if ((nodeAddress = this.primaryTable.getNodeAddress(hashSlot)) == 0L) {
                nodeAddress = this.getFallback(nodeIn, hash);
                if (nodeAddress != 0L) {
                    assert (this.lastFallbackHashSlot != -1L && this.lastFallbackNodeLength != -1);
                    this.primaryTable.setNodeAddress(hashSlot, nodeAddress);
                    this.primaryTable.copyFallbackNodeBytes(hashSlot, this.fallbackTable, this.lastFallbackHashSlot, this.lastFallbackNodeLength);
                } else {
                    long startAddress = this.fstCompiler.bytes.getPosition();
                    nodeAddress = this.fstCompiler.addNode(nodeIn);
                    assert (nodeAddress != -1L && nodeAddress != 0L);
                    byte[] buf = new byte[Math.toIntExact(nodeAddress - startAddress + 1L)];
                    this.fstCompiler.bytes.writeTo(startAddress, buf, 0, buf.length);
                    this.primaryTable.setNodeAddress(hashSlot, nodeAddress);
                    this.primaryTable.copyNodeBytes(hashSlot, buf);
                    assert (this.primaryTable.hash(nodeAddress, hashSlot) == hash) : "mismatch frozenHash=" + this.primaryTable.hash(nodeAddress, hashSlot) + " vs hash=" + hash;
                }
                long copiedBytes = this.primaryTable.copiedNodes.getPosition();
                long ramBytesUsed = this.primaryTable.count * 2L * (long)PackedInts.bitsRequired(nodeAddress) / 8L + this.primaryTable.count * 2L * (long)PackedInts.bitsRequired(copiedBytes) / 8L + copiedBytes;
                if (ramBytesUsed >= this.ramLimitBytes / 2L) {
                    this.fallbackTable = this.primaryTable;
                    this.primaryTable = new PagedGrowableHash(nodeAddress, Math.max(16L, this.primaryTable.fstNodeAddress.size()));
                } else if ((float)this.primaryTable.count > (float)this.primaryTable.fstNodeAddress.size() * 0.6666667f) {
                    this.primaryTable.rehash(nodeAddress);
                }
                return nodeAddress;
            }
            if (this.primaryTable.nodesEqual(nodeIn, nodeAddress, hashSlot) != -1) {
                return nodeAddress;
            }
            hashSlot = hashSlot + (long)(++c) & this.primaryTable.mask;
        }
    }

    private long hash(FSTCompiler.UnCompiledNode<T> node) {
        int PRIME = 31;
        long h = 0L;
        for (int arcIdx = 0; arcIdx < node.numArcs; ++arcIdx) {
            FSTCompiler.Arc arc = node.arcs[arcIdx];
            h = 31L * h + (long)arc.label;
            long n = ((FSTCompiler.CompiledNode)arc.target).node;
            h = 31L * h + (long)((int)(n ^ n >> 32));
            h = 31L * h + (long)arc.output.hashCode();
            h = 31L * h + (long)arc.nextFinalOutput.hashCode();
            if (!arc.isFinal) continue;
            h += 17L;
        }
        return h;
    }

    class PagedGrowableHash {
        private PagedGrowableWriter fstNodeAddress;
        private PagedGrowableWriter copiedNodeAddress;
        private long count;
        private long mask;
        private final ByteBlockPool copiedNodes;
        private final ByteBlockPoolReverseBytesReader bytesReader;
        private static final int BLOCK_SIZE_BYTES = 262144;

        public PagedGrowableHash() {
            this.fstNodeAddress = new PagedGrowableWriter(16L, 262144, 8, 0.0f);
            this.copiedNodeAddress = new PagedGrowableWriter(16L, 262144, 8, 0.0f);
            this.mask = 15L;
            this.copiedNodes = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
            this.bytesReader = new ByteBlockPoolReverseBytesReader(this.copiedNodes);
        }

        public PagedGrowableHash(long lastNodeAddress, long size) {
            this.fstNodeAddress = new PagedGrowableWriter(size, 262144, PackedInts.bitsRequired(lastNodeAddress), 0.0f);
            this.copiedNodeAddress = new PagedGrowableWriter(size, 262144, 8, 0.0f);
            this.mask = size - 1L;
            assert ((this.mask & size) == 0L) : "size must be a power-of-2; got size=" + size + " mask=" + this.mask;
            this.copiedNodes = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
            this.bytesReader = new ByteBlockPoolReverseBytesReader(this.copiedNodes);
        }

        public byte[] getBytes(long hashSlot, int length) {
            long address = this.copiedNodeAddress.get(hashSlot);
            assert (address - (long)length + 1L >= 0L);
            byte[] buf = new byte[length];
            this.copiedNodes.readBytes(address - (long)length + 1L, buf, 0, length);
            return buf;
        }

        public long getNodeAddress(long hashSlot) {
            return this.fstNodeAddress.get(hashSlot);
        }

        public void setNodeAddress(long hashSlot, long nodeAddress) {
            assert (this.fstNodeAddress.get(hashSlot) == 0L);
            this.fstNodeAddress.set(hashSlot, nodeAddress);
            ++this.count;
        }

        void copyNodeBytes(long hashSlot, byte[] bytes) {
            assert (this.copiedNodeAddress.get(hashSlot) == 0L);
            this.copiedNodes.append(bytes);
            this.copiedNodeAddress.set(hashSlot, this.copiedNodes.getPosition() - 1L);
        }

        void copyFallbackNodeBytes(long hashSlot, PagedGrowableHash fallbackTable, long fallbackHashSlot, int nodeLength) {
            assert (this.copiedNodeAddress.get(hashSlot) == 0L);
            long fallbackAddress = fallbackTable.copiedNodeAddress.get(fallbackHashSlot);
            long fallbackStartAddress = fallbackAddress - (long)nodeLength + 1L;
            assert (fallbackStartAddress >= 0L);
            this.copiedNodes.append(fallbackTable.copiedNodes, fallbackStartAddress, nodeLength);
            this.copiedNodeAddress.set(hashSlot, this.copiedNodes.getPosition() - 1L);
        }

        private void rehash(long lastNodeAddress) throws IOException {
            long newSize = 2L * this.fstNodeAddress.size();
            PagedGrowableWriter newCopiedNodeAddress = new PagedGrowableWriter(newSize, 262144, PackedInts.bitsRequired(this.copiedNodes.getPosition()), 0.0f);
            PagedGrowableWriter newFSTNodeAddress = new PagedGrowableWriter(newSize, 262144, PackedInts.bitsRequired(lastNodeAddress), 0.0f);
            long newMask = newFSTNodeAddress.size() - 1L;
            block0: for (long idx = 0L; idx < this.fstNodeAddress.size(); ++idx) {
                long address = this.fstNodeAddress.get(idx);
                if (address == 0L) continue;
                long hashSlot = this.hash(address, idx) & newMask;
                int c = 0;
                while (true) {
                    if (newFSTNodeAddress.get(hashSlot) == 0L) {
                        newFSTNodeAddress.set(hashSlot, address);
                        newCopiedNodeAddress.set(hashSlot, this.copiedNodeAddress.get(idx));
                        continue block0;
                    }
                    hashSlot = hashSlot + (long)(++c) & newMask;
                }
            }
            this.mask = newMask;
            this.fstNodeAddress = newFSTNodeAddress;
            this.copiedNodeAddress = newCopiedNodeAddress;
        }

        private long hash(long nodeAddress, long hashSlot) throws IOException {
            FST.BytesReader in = this.getBytesReader(nodeAddress, hashSlot);
            int PRIME = 31;
            long h = 0L;
            NodeHash.this.fstCompiler.fst.readFirstRealTargetArc(nodeAddress, NodeHash.this.scratchArc, in);
            while (true) {
                h = 31L * h + (long)NodeHash.this.scratchArc.label();
                h = 31L * h + (long)((int)(NodeHash.this.scratchArc.target() ^ NodeHash.this.scratchArc.target() >> 32));
                h = 31L * h + (long)NodeHash.this.scratchArc.output().hashCode();
                h = 31L * h + (long)NodeHash.this.scratchArc.nextFinalOutput().hashCode();
                if (NodeHash.this.scratchArc.isFinal()) {
                    h += 17L;
                }
                if (NodeHash.this.scratchArc.isLast()) break;
                NodeHash.this.fstCompiler.fst.readNextRealArc(NodeHash.this.scratchArc, in);
            }
            return h;
        }

        private int nodesEqual(FSTCompiler.UnCompiledNode<T> node, long address, long hashSlot) throws IOException {
            FST.BytesReader in = this.getBytesReader(address, hashSlot);
            NodeHash.this.fstCompiler.fst.readFirstRealTargetArc(address, NodeHash.this.scratchArc, in);
            if (NodeHash.this.scratchArc.bytesPerArc() != 0) {
                assert (node.numArcs > 0);
                switch (NodeHash.this.scratchArc.nodeFlags()) {
                    case 32: {
                        if (node.numArcs == NodeHash.this.scratchArc.numArcs()) break;
                        return -1;
                    }
                    case 64: {
                        if (node.arcs[node.numArcs - 1].label - node.arcs[0].label + 1 == NodeHash.this.scratchArc.numArcs() && node.numArcs == FST.Arc.BitTable.countBits(NodeHash.this.scratchArc, in)) break;
                        return -1;
                    }
                    case 96: {
                        if (node.arcs[node.numArcs - 1].label - node.arcs[0].label + 1 == NodeHash.this.scratchArc.numArcs()) break;
                        return -1;
                    }
                    default: {
                        throw new AssertionError((Object)("unhandled scratchArc.nodeFlag() " + NodeHash.this.scratchArc.nodeFlags()));
                    }
                }
            }
            for (int arcUpto = 0; arcUpto < node.numArcs; ++arcUpto) {
                FSTCompiler.Arc arc = node.arcs[arcUpto];
                if (arc.label != NodeHash.this.scratchArc.label() || !arc.output.equals(NodeHash.this.scratchArc.output()) || ((FSTCompiler.CompiledNode)arc.target).node != NodeHash.this.scratchArc.target() || !arc.nextFinalOutput.equals(NodeHash.this.scratchArc.nextFinalOutput()) || arc.isFinal != NodeHash.this.scratchArc.isFinal()) {
                    return -1;
                }
                if (NodeHash.this.scratchArc.isLast()) {
                    if (arcUpto == node.numArcs - 1) {
                        return Math.toIntExact(address - in.getPosition());
                    }
                    return -1;
                }
                NodeHash.this.fstCompiler.fst.readNextRealArc(NodeHash.this.scratchArc, in);
            }
            return -1;
        }

        private FST.BytesReader getBytesReader(long nodeAddress, long hashSlot) {
            assert (this.fstNodeAddress.get(hashSlot) == nodeAddress);
            long localAddress = this.copiedNodeAddress.get(hashSlot);
            this.bytesReader.setPosDelta(nodeAddress - localAddress);
            return this.bytesReader;
        }
    }
}

